/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stringbased;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.eviction.EvictionType;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.impl.table.TableManager;
import org.infinispan.persistence.jdbc.impl.table.TableManagerFactory;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.stringbased.AbstractStringBasedCacheStore")
public abstract class AbstractStringBasedCacheStore {
    protected DefaultCacheManager dcm;
    protected ConnectionFactory connectionFactory;
    protected TableManager tableManager;
    protected TableManipulationConfiguration tableConfiguration;
    protected Cache<String, String> cache;

    @Test
    public void testPutGetRemoveWithoutPassivationWithPreload() throws Exception {
        try {
            this.dcm = this.configureCacheManager(false, true, false);
            this.cache = this.dcm.getCache();
            this.assertCleanCacheAndStore(this.cache);
            this.cache.put((Object)"k1", (Object)"v1");
            this.cache.put((Object)"k2", (Object)"v2");
            AssertJUnit.assertNotNull((Object)this.getValueByKey("k1"));
            AssertJUnit.assertNotNull((Object)this.getValueByKey("k2"));
            this.cache.stop();
            this.cache.start();
            AssertJUnit.assertNotNull((Object)this.getValueByKey("k1"));
            AssertJUnit.assertNotNull((Object)this.getValueByKey("k2"));
            AssertJUnit.assertEquals((String)"v1", (String)((String)this.cache.get((Object)"k1")));
            AssertJUnit.assertEquals((String)"v2", (String)((String)this.cache.get((Object)"k2")));
            this.cache.remove((Object)"k1");
            AssertJUnit.assertNull((Object)this.cache.get((Object)"k1"));
            AssertJUnit.assertNull((Object)this.getValueByKey("k1"));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.dcm});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.dcm});
    }

    @Test
    public void testPutGetRemoveWithPassivationWithoutPreload() throws Exception {
        try {
            this.dcm = this.configureCacheManager(true, false, true);
            this.cache = this.dcm.getCache();
            this.assertCleanCacheAndStore(this.cache);
            this.cache.put((Object)"k1", (Object)"v1");
            this.cache.put((Object)"k2", (Object)"v2");
            AssertJUnit.assertNull((Object)this.getValueByKey("k1"));
            AssertJUnit.assertNull((Object)this.getValueByKey("k2"));
            this.cache.put((Object)"k3", (Object)"v3");
            AssertJUnit.assertEquals((String)"v3", (String)((String)this.cache.get((Object)"k3")));
            AssertJUnit.assertEquals((int)2, (int)this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).size());
            AssertJUnit.assertEquals((int)1, (int)this.getAllRows().size());
            this.cache.get((Object)"k1");
            this.cache.get((Object)"k2");
            AssertJUnit.assertEquals((int)2, (int)this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).size());
            AssertJUnit.assertEquals((int)1, (int)this.getAllRows().size());
            this.cache.stop();
            this.cache.start();
            AssertJUnit.assertEquals((int)0, (int)this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).size());
            AssertJUnit.assertEquals((int)3, (int)this.getAllRows().size());
            AssertJUnit.assertNotNull((Object)this.getValueByKey("k1"));
            AssertJUnit.assertEquals((String)"v1", (String)((String)this.cache.get((Object)"k1")));
            this.cache.remove((Object)"k1");
            AssertJUnit.assertNull((Object)this.cache.get((Object)"k1"));
            AssertJUnit.assertNull((Object)this.getValueByKey("k1"));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.dcm});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.dcm});
    }

    public DefaultCacheManager configureCacheManager(boolean passivation, boolean preload, boolean eviction) throws Exception {
        GlobalConfiguration glob = new GlobalConfigurationBuilder().nonClusteredDefault().defaultCacheName("StringBasedCache").build();
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)builder.persistence().passivation(passivation).addStore(JdbcStringBasedStoreConfigurationBuilder.class)).preload(preload);
        this.connectionFactory = this.getConnectionFactory(storeBuilder);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table());
        if (eviction) {
            builder.memory().evictionType(EvictionType.COUNT).size(2L);
        } else {
            builder.memory().evictionType(EvictionType.COUNT).size(-1L);
        }
        Configuration configuration = builder.build();
        this.tableConfiguration = storeBuilder.create().table();
        DefaultCacheManager defaultCacheManager = new DefaultCacheManager(glob, configuration, true);
        String cacheName = defaultCacheManager.getCache().getName();
        this.tableManager = TableManagerFactory.getManager((ConnectionFactory)this.connectionFactory, (JdbcStringBasedStoreConfiguration)storeBuilder.create(), (String)cacheName);
        return defaultCacheManager;
    }

    protected abstract ConnectionFactory getConnectionFactory(JdbcStringBasedStoreConfigurationBuilder var1);

    protected void assertCleanCacheAndStore(Cache cache) throws Exception {
        cache.clear();
        this.deleteAllRows();
        AssertJUnit.assertEquals((int)0, (int)cache.size());
        AssertJUnit.assertNull((Object)this.getValueByKey("k1"));
        AssertJUnit.assertNull((Object)this.getValueByKey("k2"));
    }

    public Object getValueByKey(String key) throws Exception {
        Object result = null;
        Connection connection = this.connectionFactory.getConnection();
        PreparedStatement ps = connection.prepareStatement(this.tableManager.getSelectIdRowSql());
        ps.setString(1, key);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = rs.getObject(this.tableConfiguration.idColumnName());
        }
        this.connectionFactory.releaseConnection(connection);
        return result;
    }

    private List<String> getAllRows() throws Exception {
        Connection connection = this.connectionFactory.getConnection();
        Statement s = connection.createStatement();
        ResultSet rs = s.executeQuery(this.tableManager.getLoadAllRowsSql());
        ArrayList<String> rows = new ArrayList<String>();
        while (rs.next()) {
            rows.add(rs.toString());
        }
        this.connectionFactory.releaseConnection(connection);
        return rows;
    }

    private void deleteAllRows() throws Exception {
        Connection connection = this.connectionFactory.getConnection();
        Statement s = connection.createStatement();
        s.executeUpdate(this.tableManager.getDeleteAllRowsSql());
        this.connectionFactory.releaseConnection(connection);
    }
}

