/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stringbased;

import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.ManagedConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.impl.connectionfactory.ManagedConnectionFactory;
import org.infinispan.persistence.jdbc.impl.connectionfactory.SimpleConnectionFactory;
import org.infinispan.persistence.jdbc.stringbased.AbstractStringBasedCacheStore;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.stringbased.StringStoreWithManagedConnectionFunctionalTest")
public class StringStoreWithManagedConnectionFunctionalTest
extends AbstractStringBasedCacheStore {
    private ManagedConnectionFactoryConfiguration customFactoryConfiguration;

    public StringStoreWithManagedConnectionFunctionalTest() {
    }

    public StringStoreWithManagedConnectionFunctionalTest(ManagedConnectionFactoryConfiguration customFactoryConfiguration) {
        this.customFactoryConfiguration = customFactoryConfiguration;
    }

    @Override
    protected ConnectionFactory getConnectionFactory(JdbcStringBasedStoreConfigurationBuilder storeBuilder) {
        if (this.customFactoryConfiguration != null) {
            ManagedConnectionFactoryConfiguration connectionFactoryConfiguration = storeBuilder.dataSource().read(this.customFactoryConfiguration).create();
            ConnectionFactory connectionFactory = ConnectionFactory.getConnectionFactory(ManagedConnectionFactory.class);
            connectionFactory.start((ConnectionFactoryConfiguration)connectionFactoryConfiguration, connectionFactory.getClass().getClassLoader());
            return connectionFactory;
        }
        SimpleConnectionFactory simpleFactory = new SimpleConnectionFactory();
        simpleFactory.start((ConnectionFactoryConfiguration)UnitTestDatabaseManager.configureSimpleConnectionFactory(storeBuilder).create(), Thread.currentThread().getContextClassLoader());
        return simpleFactory;
    }
}

