/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.impl.table;

import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.impl.table.AbstractTableManager;
import org.infinispan.persistence.jdbc.impl.table.DbMetaData;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.util.logging.LogFactory;

class SybaseTableManager
extends AbstractTableManager {
    private static final Log LOG = (Log)LogFactory.getLog(SybaseTableManager.class, Log.class);

    SybaseTableManager(ConnectionFactory connectionFactory, TableManipulationConfiguration config, DbMetaData metaData, String cacheName) {
        super(connectionFactory, config, metaData, cacheName, LOG);
    }

    @Override
    protected String getDropTimestampSql(String indexName) {
        return String.format("DROP INDEX %s.%s", this.tableName, this.getIndexName(true, indexName));
    }

    @Override
    protected String initUpdateRowSql() {
        return String.format("UPDATE %s SET %s = ? , %s = ? WHERE %s = convert(%s,?)", this.tableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName(), this.config.idColumnType());
    }

    @Override
    protected String initSelectRowSql() {
        return String.format("SELECT %s, %s FROM %s WHERE %s = convert(%s,?)", this.config.idColumnName(), this.config.dataColumnName(), this.tableName, this.config.idColumnName(), this.config.idColumnType());
    }

    @Override
    protected String initSelectIdRowSql() {
        return String.format("SELECT %s FROM %s WHERE %s = convert(%s,?)", this.config.idColumnName(), this.tableName, this.config.idColumnName(), this.config.idColumnType());
    }

    @Override
    protected String initDeleteRowSql() {
        return String.format("DELETE FROM %s WHERE %s = convert(%s,?)", this.tableName, this.config.idColumnName(), this.config.idColumnType());
    }

    @Override
    protected String initUpsertRowSql() {
        if (this.metaData.isSegmentedDisabled()) {
            return String.format("MERGE INTO %1$s AS t USING (SELECT ? %2$s, ? %3$s, ? %4$s) AS tmp ON (t.%4$s = tmp.%4$s) WHEN MATCHED THEN UPDATE SET t.%2$s = tmp.%2$s, t.%3$s = tmp.%3$s WHEN NOT MATCHED THEN INSERT VALUES (tmp.%4$s, tmp.%2$s, tmp.%3$s)", this.tableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName());
        }
        return String.format("MERGE INTO %1$s AS t USING (SELECT ? %2$s, ? %3$s, ? %4$s, ? %5$s) AS tmp ON (t.%4$s = tmp.%4$s) WHEN MATCHED THEN UPDATE SET t.%2$s = tmp.%2$s, t.%3$s = tmp.%3$s WHEN NOT MATCHED THEN INSERT VALUES (tmp.%4$s, tmp.%2$s, tmp.%3$s, tmp.%5$s)", this.tableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName(), this.config.segmentColumnName());
    }
}

