/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stringbased;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.BaseStoreTest;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.UnitTestDatabaseManager;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.impl.table.TableManager;
import org.infinispan.persistence.jdbc.stringbased.JdbcStringBasedStore;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.stringbased.JdbcStringBasedStoreTest")
public class JdbcStringBasedStoreTest
extends BaseStoreTest {
    boolean segmented;

    public JdbcStringBasedStoreTest segmented(boolean segmented) {
        this.segmented = segmented;
        return this;
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new JdbcStringBasedStoreTest().segmented(false), new JdbcStringBasedStoreTest().segmented(true)};
    }

    protected String parameters() {
        return "[" + this.segmented + "]";
    }

    protected AdvancedLoadWriteStore createStore() throws Exception {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)builder.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        storeBuilder.segmented(this.segmented);
        UnitTestDatabaseManager.configureUniqueConnectionFactory(storeBuilder);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table());
        JdbcStringBasedStore stringBasedCacheStore = new JdbcStringBasedStore();
        stringBasedCacheStore.init(this.createContext(builder.build()));
        return stringBasedCacheStore;
    }

    public void testNotCreateConnectionFactory() throws Exception {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)builder.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).manageConnectionFactory(false)).dialect(DatabaseType.H2)).dbMajorVersion(Integer.valueOf(1))).dbMinorVersion(Integer.valueOf(4));
        ((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)storeBuilder.table().createOnStart(false)).tableNamePrefix("mock_table_name");
        JdbcStringBasedStore stringBasedCacheStore = new JdbcStringBasedStore();
        stringBasedCacheStore.init(this.createContext(builder.build()));
        stringBasedCacheStore.start();
        AssertJUnit.assertNull((Object)stringBasedCacheStore.getConnectionFactory());
        ConnectionFactory connectionFactory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
        TableManager tableManager = (TableManager)Mockito.mock(TableManager.class);
        tableManager.start();
        stringBasedCacheStore.initializeConnectionFactory(connectionFactory);
        Mockito.reset((Object[])new Object[]{tableManager, connectionFactory});
        tableManager.stop();
        stringBasedCacheStore.stop();
    }

    protected boolean storePurgesAllExpired() {
        return false;
    }
}

