/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.Self;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationChildBuilder;
import org.infinispan.persistence.jdbc.configuration.DataColumnConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.IdColumnConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.SegmentColumnConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.configuration.TimestampColumnConfigurationBuilder;
import org.infinispan.persistence.jdbc.logging.Log;

public abstract class TableManipulationConfigurationBuilder<B extends AbstractJdbcStoreConfigurationBuilder<?, B>, S extends TableManipulationConfigurationBuilder<B, S>>
extends AbstractJdbcStoreConfigurationChildBuilder<B>
implements Builder<TableManipulationConfiguration>,
Self<S>,
ConfigurationBuilderInfo {
    private static final Log log = (Log)LogFactory.getLog(TableManipulationConfigurationBuilder.class, Log.class);
    private final AttributeSet attributes;
    private final DataColumnConfigurationBuilder dataColumn = new DataColumnConfigurationBuilder();
    private final IdColumnConfigurationBuilder idColumn = new IdColumnConfigurationBuilder();
    private final TimestampColumnConfigurationBuilder timeStampColumn = new TimestampColumnConfigurationBuilder();
    private final SegmentColumnConfigurationBuilder segmentColumn = new SegmentColumnConfigurationBuilder();
    private List<ConfigurationBuilderInfo> subElements;

    TableManipulationConfigurationBuilder(AbstractJdbcStoreConfigurationBuilder<?, B> builder) {
        super(builder);
        this.attributes = TableManipulationConfiguration.attributeSet();
        this.subElements = Arrays.asList(this.idColumn, this.dataColumn, this.timeStampColumn, this.segmentColumn);
    }

    public ElementDefinition getElementDefinition() {
        return TableManipulationConfiguration.ELEMENT_DEFINITION;
    }

    public Collection<ConfigurationBuilderInfo> getChildrenInfo() {
        return this.subElements;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    @Deprecated
    public S batchSize(int batchSize) {
        this.attributes.attribute(TableManipulationConfiguration.BATCH_SIZE).set((Object)batchSize);
        this.maxBatchSize(batchSize);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S fetchSize(int fetchSize) {
        this.attributes.attribute(TableManipulationConfiguration.FETCH_SIZE).set((Object)fetchSize);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S tableNamePrefix(String tableNamePrefix) {
        this.attributes.attribute(TableManipulationConfiguration.TABLE_NAME_PREFIX).set((Object)tableNamePrefix);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    String tableNamePrefix() {
        return (String)this.attributes.attribute(TableManipulationConfiguration.TABLE_NAME_PREFIX).get();
    }

    public S createOnStart(boolean createOnStart) {
        this.attributes.attribute(TableManipulationConfiguration.CREATE_ON_START).set((Object)createOnStart);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S dropOnExit(boolean dropOnExit) {
        this.attributes.attribute(TableManipulationConfiguration.DROP_ON_EXIT).set((Object)dropOnExit);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S idColumnName(String idColumnName) {
        this.idColumn.idColumnName(idColumnName);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S idColumnType(String idColumnType) {
        this.idColumn.idColumnType(idColumnType);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S dataColumnName(String dataColumnName) {
        this.dataColumn.dataColumnName(dataColumnName);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S dataColumnType(String dataColumnType) {
        this.dataColumn.dataColumnType(dataColumnType);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S timestampColumnName(String timestampColumnName) {
        this.timeStampColumn.dataColumnName(timestampColumnName);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S timestampColumnType(String timestampColumnType) {
        this.timeStampColumn.dataColumnType(timestampColumnType);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S segmentColumnName(String segmentColumnName) {
        this.segmentColumn.columnName(segmentColumnName);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S segmentColumnType(String segmentColumnType) {
        this.segmentColumn.columnType(segmentColumnType);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public void validate() {
        TableManipulationConfigurationBuilder.validateIfSet(this.attributes, TableManipulationConfiguration.TABLE_NAME_PREFIX);
        this.idColumn.validate();
        this.dataColumn.validate();
        this.timeStampColumn.validate();
        this.segmentColumn.validate();
    }

    static void validateIfSet(AttributeSet attributes, AttributeDefinition<?> ... definitions) {
        for (AttributeDefinition<?> definition : definitions) {
            String value = (String)attributes.attribute(definition).asObject();
            if (value != null && !value.isEmpty()) continue;
            throw log.tableManipulationAttributeNotSet(definition.name());
        }
    }

    public void validate(GlobalConfiguration globalConfig) {
    }

    public TableManipulationConfiguration create() {
        return new TableManipulationConfiguration(this.attributes.protect(), this.idColumn.create(), this.dataColumn.create(), this.timeStampColumn.create(), this.segmentColumn.create());
    }

    public Builder<?> read(TableManipulationConfiguration template) {
        this.attributes.read(template.attributes());
        this.idColumn.read(template.idColumnConfiguration());
        this.dataColumn.read(template.dataColumnConfiguration());
        this.timeStampColumn.read(template.timeStampColumnConfiguration());
        this.segmentColumn.read(template.segmentColumnConfiguration());
        return this;
    }

    public String toString() {
        return "TableManipulationConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

