/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.logging;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.persistence.spi.PersistenceException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface Log
extends BasicLogger {
    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception while marshalling object: %s", id=65)
    public void errorMarshallingObject(@Cause Throwable var1, Object var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed clearing cache store", id=8001)
    public void failedClearingJdbcCacheStore(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="I/O failure while integrating state into store", id=8002)
    public void ioErrorIntegratingState(@Cause IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="SQL failure while integrating state into store", id=8003)
    public void sqlFailureIntegratingState(@Cause SQLException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Class not found while integrating state into store", id=8004)
    public void classNotFoundIntegratingState(@Cause ClassNotFoundException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="I/O Error while storing string keys to database", id=8005)
    public void ioErrorStoringKeys(@Cause IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="SQL Error while storing string keys to database", id=8006)
    public void sqlFailureStoringKeys(@Cause SQLException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="SQL error while fetching all StoredEntries", id=8007)
    public void sqlFailureFetchingAllStoredEntries(@Cause SQLException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="I/O failure while marshalling bucket: %s", id=8008)
    public void errorMarshallingBucket(@Cause IOException var1, Object var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="I/O error while unmarshalling from stream", id=8009)
    public void ioErrorUnmarshalling(@Cause IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="*UNEXPECTED* ClassNotFoundException. This should not happen as Bucket class exists", id=8010)
    public void unexpectedClassNotFoundException(@Cause ClassNotFoundException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while creating table; used DDL statement: '%s'", id=8011)
    public void errorCreatingTable(String var1, @Cause SQLException var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Sql failure while loading key: %s", id=8014)
    public void sqlFailureLoadingKey(String var1, @Cause SQLException var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Could not find a connection in jndi under the name '%s'", id=8015)
    public void connectionInJndiNotFound(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Could not lookup connection with datasource %s", id=8016)
    public void namingExceptionLookingUpConnection(String var1, @Cause NamingException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed to close naming context.", id=8017)
    public void failedClosingNamingCtx(@Cause NamingException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Sql failure retrieving connection from datasource", id=8018)
    public void sqlFailureRetrievingConnection(@Cause SQLException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Issues while closing connection %s", id=8019)
    public void sqlFailureClosingConnection(Connection var1, @Cause SQLException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unexpected sql failure", id=8022)
    public void sqlFailureUnexpected(@Cause SQLException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failure while closing the connection to the database", id=8023)
    public void failureClosingConnection(@Cause SQLException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while storing string key to database; key: '%s'", id=8024)
    public void sqlFailureStoringKey(String var1, @Cause SQLException var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while removing string keys from database", id=8025)
    public void sqlFailureRemovingKeys(@Cause SQLException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="In order for JdbcStringBasedStore to support %s, the Key2StringMapper needs to implement TwoWayKey2StringMapper. You should either make %s implement TwoWayKey2StringMapper or disable the sql. See [https://jira.jboss.org/browse/ISPN-579] for more details.", id=8026)
    public void invalidKey2StringMapper(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="SQL error while fetching stored entry with key: %s, lockingKey: %s", id=8027)
    public void sqlFailureReadingKey(Object var1, String var2, @Cause SQLException var3);

    @Message(value="Attribute '%s' has not been set", id=8028)
    public CacheConfigurationException tableManipulationAttributeNotSet(String var1);

    @Message(value="A ConnectionFactory has not been specified for this store", id=8029)
    public CacheConfigurationException missingConnectionFactory();

    @Message(value="Cannot specify a ConnectionFactory and manageConnectionFactory at the same time", id=8030)
    public CacheConfigurationException unmanagedConnectionFactory();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error committing JDBC transaction", id=8031)
    public void sqlFailureTxCommit(@Cause SQLException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error during rollback of JDBC transaction", id=8032)
    public void sqlFailureTxRollback(@Cause SQLException var1);

    @Message(value="Exception encountered when preparing JDBC store Tx", id=8033)
    public PersistenceException prepareTxFailure(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to notify the PurgeListener of expired cache entries as the configured key2StringMapper does not implement %s", id=8036)
    public void twoWayKey2StringMapperIsMissing(String var1);

    @Message(value="Error while writing entries in batch to the database:", id=8037)
    public PersistenceException sqlFailureWritingBatch(@Cause Throwable var1);

    @Message(value="Error whilst removing keys in batch from the database. Keys: %s", id=8038)
    public PersistenceException sqlFailureDeletingBatch(Iterable<Object> var1, @Cause Exception var2);
}

