/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.infinispan.commons.util.Version;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfiguration;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.jdbc.configuration.XmlFileParsingTest")
public class XmlFileParsingTest
extends AbstractInfinispanTest {
    protected EmbeddedCacheManager cacheManager;

    @AfterMethod
    public void cleanup() {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    public void testStringKeyedJdbcStore() throws Exception {
        String config = TestingUtil.wrapXMLWithSchema((String)("   <cache-container default-cache=\"default\">\n     <transport/>\n      <distributed-cache name=\"default\">\n     <persistence>\n       <string-keyed-jdbc-store xmlns=\"urn:infinispan:config:store:jdbc:" + Version.getSchemaVersion() + "\" key-to-string-mapper=\"DummyKey2StringMapper\" shared=\"true\"                                 preload=\"true\" read-only=\"true\" fetch-state=\"true\" dialect=\"H2\">\n         <connection-pool connection-url=\"jdbc:h2:mem:infinispan;DB_CLOSE_DELAY=-1\" username=\"dbuser\" password=\"dbpass\" driver=\"org.h2.Driver\"/>\n         <string-keyed-table prefix=\"entry\" fetch-size=\"34\" batch-size=\"128\" >\n           <id-column name=\"id\" type=\"VARCHAR\" />\n           <data-column name=\"datum\" type=\"BINARY\" />\n           <timestamp-column name=\"version\" type=\"BIGINT\" />\n           <segment-column name=\"segfault\" type=\"BIGINT\" />\n         </string-keyed-table>\n         <write-behind />\n       </string-keyed-jdbc-store>\n     </persistence>\n   </distributed-cache></cache-container>\n"));
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        this.cacheManager = TestCacheManagerFactory.fromStream((InputStream)is, (boolean)true, (boolean)false);
        AssertJUnit.assertEquals((int)1, (int)this.cacheManager.getDefaultCacheConfiguration().persistence().stores().size());
        JdbcStringBasedStoreConfiguration store = (JdbcStringBasedStoreConfiguration)this.cacheManager.getDefaultCacheConfiguration().persistence().stores().get(0);
        AssertJUnit.assertEquals((int)128, (int)store.table().batchSize());
        AssertJUnit.assertEquals((int)34, (int)store.table().fetchSize());
        AssertJUnit.assertEquals((String)"BINARY", (String)store.table().dataColumnType());
        AssertJUnit.assertEquals((String)"version", (String)store.table().timestampColumnName());
        AssertJUnit.assertEquals((String)"segfault", (String)store.table().segmentColumnName());
        AssertJUnit.assertTrue((boolean)store.async().enabled());
        AssertJUnit.assertEquals((String)"DummyKey2StringMapper", (String)store.key2StringMapper());
        AssertJUnit.assertTrue((boolean)store.shared());
        AssertJUnit.assertTrue((boolean)store.preload());
        AssertJUnit.assertEquals((Object)DatabaseType.H2, (Object)store.dialect());
        PooledConnectionFactoryConfiguration connectionFactory = (PooledConnectionFactoryConfiguration)store.connectionFactory();
        AssertJUnit.assertEquals((String)"jdbc:h2:mem:infinispan;DB_CLOSE_DELAY=-1", (String)connectionFactory.connectionUrl());
        AssertJUnit.assertEquals((String)"org.h2.Driver", (String)connectionFactory.driverClass());
        AssertJUnit.assertEquals((String)"dbuser", (String)connectionFactory.username());
        AssertJUnit.assertEquals((String)"dbpass", (String)connectionFactory.password());
        AssertJUnit.assertTrue((boolean)store.ignoreModifications());
        AssertJUnit.assertTrue((boolean)store.fetchPersistentState());
        AssertJUnit.assertFalse((boolean)store.purgeOnStartup());
    }
}

