/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.impl.table;

import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.impl.table.AbstractTableManager;
import org.infinispan.persistence.jdbc.impl.table.DbMetaData;
import org.infinispan.persistence.jdbc.impl.table.MySQLTableManager;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.util.logging.LogFactory;

class SQLServerTableManager
extends AbstractTableManager {
    private static final Log log = (Log)LogFactory.getLog(MySQLTableManager.class, Log.class);

    SQLServerTableManager(ConnectionFactory connectionFactory, TableManipulationConfiguration config, DbMetaData metaData, String cacheName) {
        super(connectionFactory, config, metaData, cacheName, log);
    }

    @Override
    public String initUpsertRowSql() {
        if (this.metaData.isSegmentedDisabled()) {
            return String.format("MERGE %1$s WITH (TABLOCK) USING (VALUES (?, ?, ?)) AS tmp (%2$s, %3$s, %4$s) ON (%1$s.%4$s = tmp.%4$s) WHEN MATCHED THEN UPDATE SET %2$s = tmp.%2$s, %3$s = tmp.%3$s WHEN NOT MATCHED THEN INSERT (%2$s, %3$s, %4$s) VALUES (tmp.%2$s, tmp.%3$s, tmp.%4$s);", this.tableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName());
        }
        return String.format("MERGE %1$s WITH (TABLOCK) USING (VALUES (?, ?, ?, ?)) AS tmp (%2$s, %3$s, %4$s, %5$s) ON (%1$s.%4$s = tmp.%4$s) WHEN MATCHED THEN UPDATE SET %2$s = tmp.%2$s, %3$s = tmp.%3$s WHEN NOT MATCHED THEN INSERT (%2$s, %3$s, %4$s, %5$s) VALUES (tmp.%2$s, tmp.%3$s, tmp.%4$s, %5$s);", this.tableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName(), this.config.segmentColumnName());
    }

    @Override
    public boolean isStringEncodingRequired() {
        return this.metaData.getMajorVersion() <= 13;
    }

    @Override
    public String encodeString(String string) {
        char[] srcChars = string.toCharArray();
        if (srcChars.length > 0 && srcChars[0] == '\ufeff') {
            char[] chars = new char[srcChars.length - 1];
            string.getChars(1, string.toCharArray().length, chars, 0);
            return new String(chars);
        }
        return string;
    }
}

