package org.infinispan.persistence.jdbc.logging;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import java.sql.SQLException;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import java.sql.Connection;
import java.io.IOException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import org.infinispan.persistence.spi.PersistenceException;
import java.lang.Throwable;
import java.lang.Object;
import javax.naming.NamingException;
import java.util.Arrays;
import java.lang.ClassNotFoundException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-08-17T05:59:07-0400")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void errorMarshallingObject(final Throwable ioe, final Object obj) {
        super.log.logf(FQCN, ERROR, ioe, errorMarshallingObject$str(), obj);
    }
    private static final String errorMarshallingObject = "ISPN000065: Exception while marshalling object: %s";
    protected String errorMarshallingObject$str() {
        return errorMarshallingObject;
    }
    @Override
    public final void failedClearingJdbcCacheStore(final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedClearingJdbcCacheStore$str());
    }
    private static final String failedClearingJdbcCacheStore = "ISPN008001: Failed clearing cache store";
    protected String failedClearingJdbcCacheStore$str() {
        return failedClearingJdbcCacheStore;
    }
    @Override
    public final void sqlFailureIntegratingState(final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureIntegratingState$str());
    }
    private static final String sqlFailureIntegratingState = "ISPN008003: SQL failure while integrating state into store";
    protected String sqlFailureIntegratingState$str() {
        return sqlFailureIntegratingState;
    }
    @Override
    public final void ioErrorUnmarshalling(final IOException e) {
        super.log.logf(FQCN, ERROR, e, ioErrorUnmarshalling$str());
    }
    private static final String ioErrorUnmarshalling = "ISPN008009: I/O error while unmarshalling from stream";
    protected String ioErrorUnmarshalling$str() {
        return ioErrorUnmarshalling;
    }
    @Override
    public final void unexpectedClassNotFoundException(final ClassNotFoundException e) {
        super.log.logf(FQCN, ERROR, e, unexpectedClassNotFoundException$str());
    }
    private static final String unexpectedClassNotFoundException = "ISPN008010: *UNEXPECTED* ClassNotFoundException. This should not happen as Bucket class exists";
    protected String unexpectedClassNotFoundException$str() {
        return unexpectedClassNotFoundException;
    }
    @Override
    public final void errorCreatingTable(final String sql, final SQLException e) {
        super.log.logf(FQCN, ERROR, e, errorCreatingTable$str(), sql);
    }
    private static final String errorCreatingTable = "ISPN008011: Error while creating table; used DDL statement: '%s'";
    protected String errorCreatingTable$str() {
        return errorCreatingTable;
    }
    @Override
    public final void connectionInJndiNotFound(final String dataSourceName) {
        super.log.logf(FQCN, ERROR, null, connectionInJndiNotFound$str(), dataSourceName);
    }
    private static final String connectionInJndiNotFound = "ISPN008015: Could not find a connection in jndi under the name '%s'";
    protected String connectionInJndiNotFound$str() {
        return connectionInJndiNotFound;
    }
    @Override
    public final void namingExceptionLookingUpConnection(final String dataSourceName, final NamingException e) {
        super.log.logf(FQCN, ERROR, e, namingExceptionLookingUpConnection$str(), dataSourceName);
    }
    private static final String namingExceptionLookingUpConnection = "ISPN008016: Could not lookup connection with datasource %s";
    protected String namingExceptionLookingUpConnection$str() {
        return namingExceptionLookingUpConnection;
    }
    @Override
    public final void failedClosingNamingCtx(final NamingException e) {
        super.log.logf(FQCN, WARN, e, failedClosingNamingCtx$str());
    }
    private static final String failedClosingNamingCtx = "ISPN008017: Failed to close naming context.";
    protected String failedClosingNamingCtx$str() {
        return failedClosingNamingCtx;
    }
    @Override
    public final void sqlFailureRetrievingConnection(final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureRetrievingConnection$str());
    }
    private static final String sqlFailureRetrievingConnection = "ISPN008018: Sql failure retrieving connection from datasource";
    protected String sqlFailureRetrievingConnection$str() {
        return sqlFailureRetrievingConnection;
    }
    @Override
    public final void sqlFailureClosingConnection(final Connection conn, final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureClosingConnection$str(), conn);
    }
    private static final String sqlFailureClosingConnection = "ISPN008019: Issues while closing connection %s";
    protected String sqlFailureClosingConnection$str() {
        return sqlFailureClosingConnection;
    }
    @Override
    public final void sqlFailureUnexpected(final SQLException e) {
        super.log.logf(FQCN, WARN, e, sqlFailureUnexpected$str());
    }
    private static final String sqlFailureUnexpected = "ISPN008022: Unexpected sql failure";
    protected String sqlFailureUnexpected$str() {
        return sqlFailureUnexpected;
    }
    @Override
    public final void failureClosingConnection(final SQLException e) {
        super.log.logf(FQCN, WARN, e, failureClosingConnection$str());
    }
    private static final String failureClosingConnection = "ISPN008023: Failure while closing the connection to the database";
    protected String failureClosingConnection$str() {
        return failureClosingConnection;
    }
    @Override
    public final void sqlFailureStoringKey(final String lockingKey, final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureStoringKey$str(), lockingKey);
    }
    private static final String sqlFailureStoringKey = "ISPN008024: Error while storing string key to database; key: '%s'";
    protected String sqlFailureStoringKey$str() {
        return sqlFailureStoringKey;
    }
    @Override
    public final void sqlFailureRemovingKeys(final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureRemovingKeys$str());
    }
    private static final String sqlFailureRemovingKeys = "ISPN008025: Error while removing string keys from database";
    protected String sqlFailureRemovingKeys$str() {
        return sqlFailureRemovingKeys;
    }
    @Override
    public final void invalidKey2StringMapper(final String where, final String className) {
        super.log.logf(FQCN, ERROR, null, invalidKey2StringMapper$str(), where, className);
    }
    private static final String invalidKey2StringMapper = "ISPN008026: In order for JdbcStringBasedStore to support %s, the Key2StringMapper needs to implement TwoWayKey2StringMapper. You should either make %s implement TwoWayKey2StringMapper or disable the sql. See [https://jira.jboss.org/browse/ISPN-579] for more details.";
    protected String invalidKey2StringMapper$str() {
        return invalidKey2StringMapper;
    }
    @Override
    public final void sqlFailureReadingKey(final Object key, final String lockingKey, final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureReadingKey$str(), key, lockingKey);
    }
    private static final String sqlFailureReadingKey = "ISPN008027: SQL error while fetching stored entry with key: %s, lockingKey: %s";
    protected String sqlFailureReadingKey$str() {
        return sqlFailureReadingKey;
    }
    private static final String tableManipulationAttributeNotSet = "ISPN008028: Attribute '%s' has not been set";
    protected String tableManipulationAttributeNotSet$str() {
        return tableManipulationAttributeNotSet;
    }
    @Override
    public final CacheConfigurationException tableManipulationAttributeNotSet(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), tableManipulationAttributeNotSet$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingConnectionFactory = "ISPN008029: A ConnectionFactory has not been specified for this store";
    protected String missingConnectionFactory$str() {
        return missingConnectionFactory;
    }
    @Override
    public final CacheConfigurationException missingConnectionFactory() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingConnectionFactory$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unmanagedConnectionFactory = "ISPN008030: Cannot specify a ConnectionFactory and manageConnectionFactory at the same time";
    protected String unmanagedConnectionFactory$str() {
        return unmanagedConnectionFactory;
    }
    @Override
    public final CacheConfigurationException unmanagedConnectionFactory() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unmanagedConnectionFactory$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void sqlFailureTxCommit(final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureTxCommit$str());
    }
    private static final String sqlFailureTxCommit = "ISPN008031: Error committing JDBC transaction";
    protected String sqlFailureTxCommit$str() {
        return sqlFailureTxCommit;
    }
    @Override
    public final void sqlFailureTxRollback(final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureTxRollback$str());
    }
    private static final String sqlFailureTxRollback = "ISPN008032: Error during rollback of JDBC transaction";
    protected String sqlFailureTxRollback$str() {
        return sqlFailureTxRollback;
    }
    private static final String prepareTxFailure = "ISPN008033: Exception encountered when preparing JDBC store Tx";
    protected String prepareTxFailure$str() {
        return prepareTxFailure;
    }
    @Override
    public final PersistenceException prepareTxFailure(final Throwable e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), prepareTxFailure$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void twoWayKey2StringMapperIsMissing(final String className) {
        super.log.logf(FQCN, WARN, null, twoWayKey2StringMapperIsMissing$str(), className);
    }
    private static final String twoWayKey2StringMapperIsMissing = "ISPN008036: Unable to notify the PurgeListener of expired cache entries as the configured key2StringMapper does not implement %s";
    protected String twoWayKey2StringMapperIsMissing$str() {
        return twoWayKey2StringMapperIsMissing;
    }
    private static final String sqlFailureWritingBatch = "ISPN008037: Error while writing entries in batch to the database:";
    protected String sqlFailureWritingBatch$str() {
        return sqlFailureWritingBatch;
    }
    @Override
    public final PersistenceException sqlFailureWritingBatch(final Throwable e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), sqlFailureWritingBatch$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sqlFailureDeletingBatch = "ISPN008038: Error whilst removing keys in batch from the database. Keys: %s";
    protected String sqlFailureDeletingBatch$str() {
        return sqlFailureDeletingBatch;
    }
    @Override
    public final PersistenceException sqlFailureDeletingBatch(final Iterable<Object> keys, final Exception e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), sqlFailureDeletingBatch$str(), keys), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
