/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stringbased;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jdbc.stringbased.NonStringKeyPreloadTest;
import org.infinispan.persistence.jdbc.stringbased.TwoWayPersonKey2StringMapper;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.Person;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.stringbased.NonStringKeyStateTransferTest")
public class NonStringKeyStateTransferTest
extends AbstractCacheTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReplicatedStateTransfer() {
        EmbeddedCacheManager cm1 = null;
        EmbeddedCacheManager cm2 = null;
        try {
            cm1 = this.createCacheManager(true, CacheMode.REPL_SYNC);
            Cache c1 = cm1.getCache();
            Person mircea = new Person("mircea");
            Person mircea2 = new Person("mircea2");
            c1.put((Object)mircea, (Object)"mircea");
            c1.put((Object)mircea2, (Object)"mircea2");
            cm2 = this.createCacheManager(true, CacheMode.REPL_SYNC);
            Cache c2 = cm2.getCache();
            AssertJUnit.assertEquals((String)"mircea", (String)((String)c2.get((Object)mircea)));
            AssertJUnit.assertEquals((String)"mircea2", (String)((String)c2.get((Object)mircea2)));
            c2.get((Object)mircea2);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm1, cm2});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm1, cm2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedStateTransfer() {
        EmbeddedCacheManager cm1 = null;
        EmbeddedCacheManager cm2 = null;
        try {
            cm1 = this.createCacheManager(false, CacheMode.DIST_SYNC);
            Cache c1 = cm1.getCache();
            for (int i = 0; i < 100; ++i) {
                Person mircea = new Person("mircea" + i);
                c1.put((Object)mircea, (Object)("mircea" + i));
            }
            cm2 = this.createCacheManager(false, CacheMode.DIST_SYNC);
            Cache c2 = cm2.getCache();
            assert (c2.size() > 0);
            for (InternalCacheEntry entry : c2.getAdvancedCache().getDataContainer()) {
                Object key = entry.getKey();
                assert (key instanceof Person) : "expected key to be person but obtained " + key;
            }
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm1, cm2});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm1, cm2});
    }

    public void testDistributedAndNoTwoWay() {
        ConfigurationBuilder config = NonStringKeyPreloadTest.createCacheStoreConfig(TwoWayPersonKey2StringMapper.class.getName(), false);
        config.clustering().cacheMode(CacheMode.DIST_SYNC);
        TestingUtil.withCacheManager(() -> TestCacheManagerFactory.createClusteredCacheManager((SerializationContextInitializer)TestDataSCI.INSTANCE, (ConfigurationBuilder)config), EmbeddedCacheManager::getCache);
    }

    private EmbeddedCacheManager createCacheManager(boolean preload, CacheMode cacheMode) {
        ConfigurationBuilder config = NonStringKeyPreloadTest.createCacheStoreConfig(TwoWayPersonKey2StringMapper.class.getName(), preload);
        config.clustering().cacheMode(cacheMode);
        return TestCacheManagerFactory.createClusteredCacheManager((SerializationContextInitializer)TestDataSCI.INSTANCE, (ConfigurationBuilder)config);
    }
}

