/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.h2.Driver;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.IdentityKeyValueWrapper;
import org.infinispan.persistence.PersistenceCompatibilityTest;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.test.data.Value;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.JdbcStoreCompatibilityTest")
public class JdbcStoreCompatibilityTest
extends PersistenceCompatibilityTest<Value> {
    private static final String DB_FILE_NAME = "jdbc_db.mv.db";
    private static final Map<PersistenceCompatibilityTest.Version, String> data = new HashMap<PersistenceCompatibilityTest.Version, String>(2);

    public JdbcStoreCompatibilityTest() {
        super(IdentityKeyValueWrapper.instance());
    }

    public void testReadWriteFrom101() throws Exception {
        this.doTestReadWriteFrom101();
    }

    protected void beforeStartCache(PersistenceCompatibilityTest.Version version) throws Exception {
        new File(this.tmpDirectory).mkdirs();
        JdbcStoreCompatibilityTest.copyFile((String)this.combinePath(data.get(version), DB_FILE_NAME), (Path)Paths.get(this.tmpDirectory, new String[0]), (String)DB_FILE_NAME);
    }

    protected String cacheName() {
        return "jdbc_store_cache";
    }

    protected void configurePersistence(ConfigurationBuilder builder) {
        JdbcStringBasedStoreConfigurationBuilder jdbcB = (JdbcStringBasedStoreConfigurationBuilder)builder.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        ((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)jdbcB.table().createOnStart(false)).tableNamePrefix("ISPN_STRING_TABLE")).idColumnName("ID_COLUMN")).idColumnType("VARCHAR(255)")).dataColumnName("DATA_COLUMN")).dataColumnType("BINARY")).timestampColumnName("TIMESTAMP_COLUMN")).timestampColumnType("BIGINT")).segmented(false);
        jdbcB.connectionPool().driverClass(Driver.class).connectionUrl(String.format("jdbc:h2:%s;DB_CLOSE_DELAY=0", this.combinePath(this.tmpDirectory, "jdbc_db"))).username("sa");
    }

    static {
        data.put(PersistenceCompatibilityTest.Version._10_1, "10_1_x_jdbc_data");
        data.put(PersistenceCompatibilityTest.Version._11_0, "11_0_x_jdbc_data");
    }
}

