/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stringbased;

import org.h2.Driver;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManagerStartupException;
import org.infinispan.persistence.jdbc.UnitTestDatabaseManager;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.stringbased.JdbcStringBasedStoreMetaTest")
public class JdbcStringBasedStoreMetaTest
extends AbstractInfinispanTest {
    public void testSegmentCompatibility() {
        this.createCacheManager(true, 10);
        try {
            this.createCacheManager(false, 15);
        }
        catch (EmbeddedCacheManagerStartupException e) {
            AssertJUnit.assertNotNull((Object)((Object)e));
            Throwable cause = e.getCause();
            AssertJUnit.assertNotNull((Object)cause);
            AssertJUnit.assertTrue((boolean)(cause instanceof CacheConfigurationException));
        }
    }

    private void createCacheManager(boolean createOnStart, int segments) {
        ConfigurationBuilder cfg = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        cfg.clustering().hash().numSegments(segments);
        JdbcStringBasedStoreConfigurationBuilder store = (JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)cfg.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).fetchPersistentState(true);
        store.table().createOnStart(createOnStart);
        UnitTestDatabaseManager.buildTableManipulation(store.table());
        store.simpleConnection().driverClass(Driver.class).connectionUrl(String.format("jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1", JdbcStringBasedStoreMetaTest.class)).username("sa");
        TestingUtil.withCacheManager(() -> TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg), Void2 -> {});
    }
}

