/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stringbased;

import java.util.function.Consumer;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jdbc.UnitTestDatabaseManager;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.stringbased.PersonKey2StringMapper;
import org.infinispan.persistence.jdbc.stringbased.TwoWayPersonKey2StringMapper;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.Person;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.stringbased.NonStringKeyPreloadTest")
public class NonStringKeyPreloadTest
extends AbstractInfinispanTest {
    public void testPreloadWithKey2StringMapper() {
        String mapperName = PersonKey2StringMapper.class.getName();
        ConfigurationBuilder config = NonStringKeyPreloadTest.createCacheStoreConfig(mapperName, true);
        TestingUtil.withCacheManager(() -> TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)TestDataSCI.INSTANCE), cm -> {
            try {
                cm.createCache("invalidCache", config.build());
                assert (false) : " Preload with Key2StringMapper is not supported. Specify an TwoWayKey2StringMapper if you want to support it (or disable preload).";
            }
            catch (CacheException e) {
                log.debugf("Ignoring expected exception", (Object)e);
            }
        });
    }

    public void testPreloadWithTwoWayKey2StringMapper() {
        String mapperName = TwoWayPersonKey2StringMapper.class.getName();
        ConfigurationBuilder config = NonStringKeyPreloadTest.createCacheStoreConfig(mapperName, true);
        Person mircea = new Person("Mircea");
        Person dan = new Person("Dan");
        this.withCacheManagerConfig(config, cm -> {
            Cache cache = cm.getCache();
            cache.put((Object)mircea, (Object)"me");
            cache.put((Object)dan, (Object)"mate");
        });
        this.withCacheManagerConfig(config, cm -> {
            Cache cache = null;
            try {
                cache = cm.getCache();
                assert (cache.containsKey((Object)mircea));
                assert (cache.containsKey((Object)dan));
            }
            finally {
                TestingUtil.clearCacheLoader((Cache)cache);
            }
        });
    }

    public void testPreloadWithTwoWayKey2StringMapperAndBoundedCache() {
        String mapperName = TwoWayPersonKey2StringMapper.class.getName();
        ConfigurationBuilder config = NonStringKeyPreloadTest.createCacheStoreConfig(mapperName, true);
        config.memory().size(3L);
        this.withCacheManagerConfig(config, cm -> {
            for (int i = 0; i < 10; ++i) {
                cm.getCache().getAdvancedCache().put((Object)new Person("name" + i), (Object)("" + i));
            }
        });
        this.withCacheManagerConfig(config, cm -> {
            AdvancedCache cache = cm.getCache().getAdvancedCache();
            AssertJUnit.assertEquals((int)3, (int)cache.getDataContainer().size());
            int found = 0;
            for (int i = 0; i < 10; ++i) {
                Person p = new Person("name" + i);
                if (!cache.getDataContainer().containsKey((Object)p)) continue;
                ++found;
            }
            AssertJUnit.assertEquals((int)3, (int)found);
        });
    }

    static ConfigurationBuilder createCacheStoreConfig(String mapperName, boolean preload) {
        ConfigurationBuilder cfg = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcStringBasedStoreConfigurationBuilder store = ((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)cfg.persistence().connectionAttempts(1).addStore(JdbcStringBasedStoreConfigurationBuilder.class)).fetchPersistentState(true)).preload(preload)).key2StringMapper(mapperName);
        UnitTestDatabaseManager.buildTableManipulation(store.table());
        UnitTestDatabaseManager.configureUniqueConnectionFactory(store);
        return cfg;
    }

    private void withCacheManagerConfig(ConfigurationBuilder config, Consumer<EmbeddedCacheManager> consumer) {
        TestingUtil.withCacheManager(() -> TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)TestDataSCI.INSTANCE, (ConfigurationBuilder)config), consumer);
    }
}

