/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.impl.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.persistence.jdbc.common.TableOperations;
import org.infinispan.persistence.jdbc.impl.table.TableName;
import org.infinispan.persistence.spi.PersistenceException;

public interface TableManager<K, V>
extends TableOperations<K, V> {
    public static final int DEFAULT_FETCH_SIZE = 100;

    public void start() throws PersistenceException;

    public void stop() throws PersistenceException;

    public boolean tableExists(Connection var1, TableName var2);

    default public boolean metaTableExists(Connection conn) {
        return this.tableExists(conn, this.getMetaTableName());
    }

    public void createDataTable(Connection var1) throws PersistenceException;

    public void dropDataTable(Connection var1) throws PersistenceException;

    public void createMetaTable(Connection var1) throws PersistenceException;

    public void dropMetaTable(Connection var1) throws PersistenceException;

    public void updateMetaTable(Connection var1) throws PersistenceException;

    public Metadata getMetadata(Connection var1) throws PersistenceException;

    default public void dropTables(Connection conn) throws PersistenceException {
        this.dropDataTable(conn);
        this.dropMetaTable(conn);
    }

    public int getFetchSize();

    public String getDeleteRowSql();

    public String getDeleteAllSql();

    public String getLoadNonExpiredAllRowsSql();

    public String getUpdateRowSql();

    public String getSelectRowSql();

    public String getLoadAllRowsSql();

    public String getSelectOnlyExpiredRowsSql();

    public boolean isUpsertSupported();

    public TableName getDataTableName();

    public TableName getMetaTableName();

    public String getIdentifierQuoteString();

    public boolean isStringEncodingRequired();

    public String encodeString(String var1);

    public void prepareUpdateStatement(PreparedStatement var1, String var2, long var3, int var5, ByteBuffer var6) throws SQLException;

    public static interface Metadata {
        public short getVersion();

        public int getSegments();
    }
}

