/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.infinispan.persistence.jdbc.common.JdbcUtil;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfigurationBuilder;
import org.infinispan.persistence.jdbc.impl.table.TableName;

public class UnitTestDatabaseManager
extends org.infinispan.persistence.jdbc.common.UnitTestDatabaseManager {
    public static void buildTableManipulation(TableManipulationConfigurationBuilder<?, ?> table) {
        table.tableNamePrefix("ISPN_STRING").idColumnName("ID_COLUMN").idColumnType("VARCHAR(255)").dataColumnName("DATA_COLUMN").dataColumnType("BLOB").timestampColumnName("TIMESTAMP_COLUMN").timestampColumnType("BIGINT").segmentColumnName("SEGMENT_COLUMN").segmentColumnType("INTEGER");
    }

    public static int rowCount(ConnectionFactory connectionFactory, TableName tableName) {
        int n;
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            conn = connectionFactory.getConnection();
            String sql = "SELECT count(*) FROM " + tableName;
            statement = conn.prepareStatement(sql);
            resultSet = statement.executeQuery();
            resultSet.next();
            n = resultSet.getInt(1);
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(resultSet);
                JdbcUtil.safeClose(statement);
                connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose((ResultSet)resultSet);
        JdbcUtil.safeClose((Statement)statement);
        connectionFactory.releaseConnection(conn);
        return n;
    }
}

