/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stringbased;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamAwareMarshaller;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.persistence.jdbc.common.JdbcUtil;
import org.infinispan.persistence.jdbc.common.TableOperations;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.common.impl.BaseJdbcStore;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.impl.table.TableManager;
import org.infinispan.persistence.jdbc.impl.table.TableManagerFactory;
import org.infinispan.persistence.keymappers.Key2StringMapper;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.MarshalledValue;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

@ConfiguredBy(value=JdbcStringBasedStoreConfiguration.class)
public class JdbcStringBasedStore<K, V>
extends BaseJdbcStore<K, V, JdbcStringBasedStoreConfiguration> {
    private static final Log log = (Log)LogFactory.getLog(JdbcStringBasedStore.class, Log.class);
    private JdbcStringBasedStoreConfiguration configuration;
    private Key2StringMapper key2StringMapper;
    private MarshallableEntryFactory<K, V> marshalledEntryFactory;
    private PersistenceMarshaller marshaller;
    private TimeService timeService;
    private KeyPartitioner keyPartitioner;

    public Set<NonBlockingStore.Characteristic> characteristics() {
        return EnumSet.of(NonBlockingStore.Characteristic.BULK_READ, NonBlockingStore.Characteristic.EXPIRATION, NonBlockingStore.Characteristic.SEGMENTABLE, NonBlockingStore.Characteristic.TRANSACTIONAL, NonBlockingStore.Characteristic.SHAREABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableOperations<K, V> createTableOperations(InitializationContext ctx, JdbcStringBasedStoreConfiguration configuration) {
        TableManager tableManager;
        block15: {
            this.configuration = (JdbcStringBasedStoreConfiguration)ctx.getConfiguration();
            this.marshalledEntryFactory = ctx.getMarshallableEntryFactory();
            this.marshaller = ctx.getPersistenceMarshaller();
            this.timeService = ctx.getTimeService();
            this.keyPartitioner = configuration.segmented() ? ctx.getKeyPartitioner() : null;
            String cacheName = ctx.getCache().getName();
            tableManager = TableManagerFactory.getManager(ctx, this.connectionFactory, configuration, ctx.getCache().getName());
            tableManager.start();
            if (!configuration.table().createOnStart()) {
                Connection connection = null;
                try {
                    connection = this.connectionFactory.getConnection();
                    if (tableManager.metaTableExists(connection)) {
                        String versionStr;
                        List versionParts;
                        TableManager.Metadata meta = tableManager.getMetadata(connection);
                        int storedSegments = meta.getSegments();
                        if (!(configuration.segmented() || (Integer)(versionParts = Arrays.stream((versionStr = Version.decodeVersion((short)meta.getVersion())).split("\\.")).map(Integer::parseInt).collect(Collectors.toList())).get(0) <= 12 && (Integer)versionParts.get(2) <= 4 || storedSegments == -1)) {
                            throw log.existingStoreNoSegmentation();
                        }
                        int configuredSegments = ctx.getCache().getCacheConfiguration().clustering().hash().numSegments();
                        if (configuration.segmented() && storedSegments != configuredSegments) {
                            throw log.existingStoreSegmentMismatch(storedSegments, configuredSegments);
                        }
                        tableManager.updateMetaTable(connection);
                        break block15;
                    }
                    org.infinispan.util.logging.Log.PERSISTENCE.startMigratingPersistenceData(cacheName);
                    try {
                        this.migrateFromV11(ctx, tableManager);
                    }
                    catch (SQLException e) {
                        throw org.infinispan.util.logging.Log.PERSISTENCE.persistedDataMigrationFailed(cacheName, (Throwable)e);
                    }
                    tableManager.createMetaTable(connection);
                    org.infinispan.util.logging.Log.PERSISTENCE.persistedDataSuccessfulMigrated(cacheName);
                }
                finally {
                    this.connectionFactory.releaseConnection(connection);
                }
            }
        }
        try {
            Object mapper = Util.loadClassStrict((String)configuration.key2StringMapper(), (ClassLoader)ctx.getGlobalConfiguration().classLoader()).newInstance();
            if (mapper instanceof Key2StringMapper) {
                this.key2StringMapper = (Key2StringMapper)mapper;
            }
        }
        catch (Exception e) {
            log.errorf("Trying to instantiate %s, however it failed due to %s", (Object)configuration.key2StringMapper(), (Object)e.getClass().getName());
            throw new IllegalStateException("This should not happen.", e);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Using key2StringMapper: %s", (Object)this.key2StringMapper.getClass().getName());
        }
        if (configuration.preload()) {
            this.enforceTwoWayMapper("preload");
        }
        if (ctx.getCache().getCacheConfiguration() != null && ctx.getCache().getCacheConfiguration().clustering().cacheMode().isDistributed()) {
            this.enforceTwoWayMapper("distribution/rehashing");
        }
        return tableManager;
    }

    public TableManager<K, V> getTableManager() {
        return (TableManager)this.tableOperations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateFromV11(InitializationContext ctx, TableManager<K, V> tableManager) throws SQLException {
        if (ctx.getGlobalConfiguration().serialization().marshaller() != null) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.connectionFactory.getConnection();
            conn.setAutoCommit(false);
            String sql = tableManager.getLoadNonExpiredAllRowsSql();
            ps = conn.prepareStatement(sql);
            ps.setLong(1, this.timeService.wallClockTime());
            rs = ps.executeQuery();
            Marshaller userMarshaller = this.marshaller.getUserMarshaller();
            try (PreparedStatement upsertBatch = conn.prepareStatement(tableManager.getUpdateRowSql());){
                int batchSize = 0;
                while (rs.next()) {
                    Metadata meta;
                    ++batchSize;
                    InputStream inputStream = rs.getBinaryStream(1);
                    String keyStr = rs.getString(2);
                    long timestamp = rs.getLong(3);
                    int segment = this.keyPartitioner == null ? -1 : rs.getInt(4);
                    MarshalledValue mv = (MarshalledValue)JdbcUtil.unmarshall((InputStream)inputStream, (StreamAwareMarshaller)this.marshaller);
                    Object value = JdbcUtil.unmarshall((ByteBuffer)mv.getValueBytes(), (Marshaller)userMarshaller);
                    try {
                        meta = (Metadata)JdbcUtil.unmarshall((ByteBuffer)mv.getMetadataBytes(), (Marshaller)userMarshaller);
                    }
                    catch (IllegalArgumentException e) {
                        meta = (Metadata)JdbcUtil.unmarshall((ByteBuffer)mv.getMetadataBytes(), (Marshaller)this.marshaller);
                    }
                    PrivateMetadata internalMeta = (PrivateMetadata)JdbcUtil.unmarshall((ByteBuffer)mv.getInternalMetadataBytes(), (Marshaller)this.marshaller);
                    MarshallableEntry entry = this.marshalledEntryFactory.create(null, value, meta, internalMeta, mv.getCreated(), mv.getLastUsed());
                    ByteBuffer byteBuffer = JdbcUtil.marshall((Object)entry.getMarshalledValue(), (Marshaller)this.marshaller);
                    tableManager.prepareUpdateStatement(upsertBatch, keyStr, timestamp, segment, byteBuffer);
                    upsertBatch.addBatch();
                    if (batchSize != this.configuration.maxBatchSize()) continue;
                    batchSize = 0;
                    upsertBatch.executeBatch();
                    upsertBatch.clearBatch();
                }
                if (batchSize != 0) {
                    upsertBatch.executeBatch();
                }
                conn.commit();
            }
        }
        catch (Throwable throwable) {
            JdbcUtil.safeClose(rs);
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
            throw throwable;
        }
        JdbcUtil.safeClose((ResultSet)rs);
        JdbcUtil.safeClose((Statement)ps);
        this.connectionFactory.releaseConnection(conn);
    }

    protected void extraStopSteps() {
        try {
            TableManager<K, V> tableManager = this.getTableManager();
            if (tableManager != null) {
                tableManager.stop();
                this.tableOperations = null;
            }
        }
        catch (Throwable t) {
            log.debug((Object)"Exception while stopping", t);
        }
    }

    public CompletionStage<Void> addSegments(IntSet segments) {
        return CompletableFutures.completedNull();
    }

    public CompletionStage<Void> removeSegments(IntSet segments) {
        return CompletableFutures.completedNull();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public Publisher<MarshallableEntry<K, V>> purgeExpired() {
        return Flowable.defer(() -> {
            UnicastProcessor unicastProcessor = UnicastProcessor.create();
            this.blockingManager.runBlocking(() -> {
                TableManager<K, V> tableManager = this.getTableManager();
                Connection conn = null;
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    String sql = tableManager.getSelectOnlyExpiredRowsSql();
                    conn = this.connectionFactory.getConnection();
                    conn.setAutoCommit(false);
                    ps = conn.prepareStatement(sql);
                    ps.setLong(1, this.timeService.wallClockTime());
                    rs = ps.executeQuery();
                    try (PreparedStatement batchDelete = conn.prepareStatement(tableManager.getDeleteRowSql());){
                        int affectedRows = 0;
                        boolean twoWayMapperExists = this.key2StringMapper instanceof TwoWayKey2StringMapper;
                        while (rs.next()) {
                            ++affectedRows;
                            String keyStr = rs.getString(2);
                            batchDelete.setString(1, keyStr);
                            batchDelete.addBatch();
                            if (!twoWayMapperExists) continue;
                            InputStream inputStream = rs.getBinaryStream(1);
                            Object key = ((TwoWayKey2StringMapper)this.key2StringMapper).getKeyMapping(keyStr);
                            MarshalledValue value = (MarshalledValue)JdbcUtil.unmarshall((InputStream)inputStream, (StreamAwareMarshaller)this.marshaller);
                            unicastProcessor.onNext((Object)this.marshalledEntryFactory.create(key, value));
                        }
                        if (!twoWayMapperExists) {
                            Log.PERSISTENCE.twoWayKey2StringMapperIsMissing(TwoWayKey2StringMapper.class.getSimpleName());
                        }
                        if (affectedRows > 0) {
                            int[] result = batchDelete.executeBatch();
                            if (log.isTraceEnabled()) {
                                log.tracef("Successfully purged %d rows.", result.length);
                            }
                        }
                        conn.commit();
                        unicastProcessor.onComplete();
                    }
                }
                catch (SQLException e) {
                    try {
                        log.failedClearingJdbcCacheStore((Exception)e);
                        try {
                            conn.rollback();
                        }
                        catch (SQLException ex) {
                            log.sqlFailureTxRollback(ex);
                        }
                        unicastProcessor.onError((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        JdbcUtil.safeClose(rs);
                        JdbcUtil.safeClose(ps);
                        this.connectionFactory.releaseConnection(conn);
                        throw throwable;
                    }
                    JdbcUtil.safeClose(rs);
                    JdbcUtil.safeClose((Statement)ps);
                    this.connectionFactory.releaseConnection(conn);
                }
                JdbcUtil.safeClose((ResultSet)rs);
                JdbcUtil.safeClose((Statement)ps);
                this.connectionFactory.releaseConnection(conn);
            }, (Object)"jdbcstringstore-purge");
            return unicastProcessor;
        });
    }

    private void enforceTwoWayMapper(String where) throws PersistenceException {
        if (!(this.key2StringMapper instanceof TwoWayKey2StringMapper)) {
            Log.PERSISTENCE.invalidKey2StringMapper(where, this.key2StringMapper.getClass().getName());
            throw new PersistenceException(String.format("Invalid key to string mapper : %s", this.key2StringMapper.getClass().getName()));
        }
    }
}

