/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.h2.Driver;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.AbstractPersistenceCompatibilityTest;
import org.infinispan.persistence.IdentityKeyValueWrapper;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.test.data.Value;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.JdbcStoreCompatibilityTest")
public class JdbcStoreCompatibilityTest
extends AbstractPersistenceCompatibilityTest<Value> {
    private static final String DB_FILE_NAME = "jdbc_db.mv.db";
    private static final Map<AbstractPersistenceCompatibilityTest.Version, String> data = new HashMap<AbstractPersistenceCompatibilityTest.Version, String>(2);

    public JdbcStoreCompatibilityTest() {
        super(IdentityKeyValueWrapper.instance());
    }

    @Test
    public void testReadWriteFrom101() throws Exception {
        this.oldVersion = AbstractPersistenceCompatibilityTest.Version._10_1;
        this.doTestReadWrite();
    }

    @Test
    public void testReadWriteFrom11() throws Exception {
        this.beforeStartCache();
        this.doTestReadWrite();
    }

    protected void beforeStartCache() throws Exception {
        new File(this.tmpDirectory).mkdirs();
        JdbcStoreCompatibilityTest.copyFile((String)this.combinePath(data.get(this.oldVersion), DB_FILE_NAME), (Path)Paths.get(this.tmpDirectory, new String[0]), (String)DB_FILE_NAME);
    }

    protected String cacheName() {
        return "jdbc_store_cache";
    }

    protected void configurePersistence(ConfigurationBuilder builder, boolean generatingData) {
        JdbcStringBasedStoreConfigurationBuilder jdbcB = (JdbcStringBasedStoreConfigurationBuilder)builder.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        jdbcB.segmented(this.oldSegmented);
        ((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)jdbcB.table().createOnStart(generatingData)).tableNamePrefix("ISPN_STRING_TABLE")).idColumnName("ID_COLUMN")).idColumnType("VARCHAR(255)")).dataColumnName("DATA_COLUMN")).dataColumnType("BINARY")).timestampColumnName("TIMESTAMP_COLUMN")).timestampColumnType("BIGINT")).segmented(false);
        jdbcB.connectionPool().driverClass(Driver.class).connectionUrl(String.format("jdbc:h2:%s;DB_CLOSE_DELAY=0", this.combinePath(this.tmpDirectory, "jdbc_db"))).username("sa");
    }

    static {
        data.put(AbstractPersistenceCompatibilityTest.Version._10_1, "10_1_x_jdbc_data");
        data.put(AbstractPersistenceCompatibilityTest.Version._11_0, "11_0_x_jdbc_data");
    }
}

