/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stringbased;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.distribution.BaseDistStoreTest;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jdbc.UnitTestDatabaseManager;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.stringbased.JdbcStringBasedStore;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.JdbcStringBasedClusterTest")
public class JdbcStringBasedClusterTest
extends BaseDistStoreTest<Integer, String, JdbcStringBasedClusterTest> {
    private ControlledTimeService controlledTimeService = new ControlledTimeService();

    public JdbcStringBasedClusterTest() {
        this.INIT_CLUSTER_SIZE = 2;
        this.l1CacheEnabled = false;
    }

    protected void amendCacheManagerBeforeStart(EmbeddedCacheManager ecm) {
        TestingUtil.replaceComponent((CacheContainer)ecm, TimeService.class, (Object)this.controlledTimeService, (boolean)true);
    }

    public Object[] factory() {
        return new Object[]{((JdbcStringBasedClusterTest)((JdbcStringBasedClusterTest)new JdbcStringBasedClusterTest().segmented(true)).shared(true)).cacheMode(CacheMode.DIST_SYNC), ((JdbcStringBasedClusterTest)((JdbcStringBasedClusterTest)new JdbcStringBasedClusterTest().segmented(false)).shared(true)).cacheMode(CacheMode.DIST_SYNC), ((JdbcStringBasedClusterTest)new JdbcStringBasedClusterTest().segmented(true)).cacheMode(CacheMode.LOCAL), ((JdbcStringBasedClusterTest)new JdbcStringBasedClusterTest().segmented(false)).cacheMode(CacheMode.LOCAL)};
    }

    protected StoreConfigurationBuilder addStore(PersistenceConfigurationBuilder persistenceConfigurationBuilder, boolean shared) {
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)persistenceConfigurationBuilder.addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        storeBuilder.shared(shared);
        storeBuilder.segmented(this.segmented);
        UnitTestDatabaseManager.configureUniqueConnectionFactory((AbstractJdbcStoreConfigurationBuilder)storeBuilder);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table());
        return storeBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPurgeExpired() throws SQLException {
        Cache cacheToUse = this.cache(0, this.cacheName);
        cacheToUse.put((Object)"key1", (Object)"expired", 10L, TimeUnit.MINUTES);
        cacheToUse.put((Object)"key2", (Object)"value");
        cacheToUse.put((Object)"key3", (Object)"expired", 10L, TimeUnit.MINUTES);
        cacheToUse.put((Object)"key4", (Object)"value");
        AssertJUnit.assertEquals((int)4, (int)this.cache(0, this.cacheName).size());
        for (int i = 0; i < this.cacheManagers.size(); ++i) {
            ((InternalDataContainer)TestingUtil.extractComponent((Cache)this.cache(i, this.cacheName), InternalDataContainer.class)).clear();
        }
        AssertJUnit.assertEquals((int)4, (int)cacheToUse.size());
        this.controlledTimeService.advance(TimeUnit.MINUTES.toMillis(11L));
        PersistenceManager persistenceManager = (PersistenceManager)TestingUtil.extractComponent((Cache)this.cache(0, this.cacheName), PersistenceManager.class);
        CompletionStages.join((CompletionStage)persistenceManager.purgeExpired());
        AssertJUnit.assertEquals((int)2, (int)cacheToUse.size());
        JdbcStringBasedStore jdbcStringBasedStore = (JdbcStringBasedStore)persistenceManager.getStores(JdbcStringBasedStore.class).iterator().next();
        ConnectionFactory connectionFactory = jdbcStringBasedStore.getConnectionFactory();
        Connection connection = connectionFactory.getConnection();
        try (Statement stat = connection.createStatement();
             ResultSet rs = stat.executeQuery("SELECT COUNT(1) FROM " + jdbcStringBasedStore.getTableManager().getDataTableName());){
            AssertJUnit.assertTrue((boolean)rs.next());
            AssertJUnit.assertEquals((int)2, (int)rs.getInt(1));
            AssertJUnit.assertFalse((boolean)rs.next());
        }
        finally {
            connectionFactory.releaseConnection(connection);
        }
    }
}

