/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.jdbc.UnitTestDatabaseManager;
import org.infinispan.persistence.jdbc.common.configuration.ManagedConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.PooledConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.jdbc.configuration.ConfigurationTest")
public class ConfigurationTest {
    private static final String JDBC_URL = "jdbc:h2:mem:infinispan;DB_CLOSE_DELAY=-1";

    public void testImplicitPooledConnectionFactory() {
        ConfigurationBuilder b = new ConfigurationBuilder();
        JdbcStringBasedStoreConfigurationBuilder jdbc = (JdbcStringBasedStoreConfigurationBuilder)b.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        UnitTestDatabaseManager.buildTableManipulation(jdbc.table());
        jdbc.connectionPool().connectionUrl(JDBC_URL);
        Configuration configuration = b.build();
        JdbcStringBasedStoreConfiguration store = (JdbcStringBasedStoreConfiguration)configuration.persistence().stores().get(0);
        assert (store.connectionFactory() instanceof PooledConnectionFactoryConfiguration);
    }

    public void testImplicitManagedConnectionFactory() {
        ConfigurationBuilder b = new ConfigurationBuilder();
        JdbcStringBasedStoreConfigurationBuilder jdbc = (JdbcStringBasedStoreConfigurationBuilder)b.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        UnitTestDatabaseManager.buildTableManipulation(jdbc.table());
        jdbc.dataSource().jndiUrl("java:jboss/datasources/ExampleDS");
        Configuration configuration = b.build();
        JdbcStringBasedStoreConfiguration store = (JdbcStringBasedStoreConfiguration)configuration.persistence().stores().get(0);
        assert (store.connectionFactory() instanceof ManagedConnectionFactoryConfiguration);
    }

    public void testJdbcStringCacheStoreConfigurationAdaptor() {
        ConfigurationBuilder b = new ConfigurationBuilder();
        ((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)b.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).connectionPool().connectionUrl(JDBC_URL).fetchPersistentState(true)).table().tableNamePrefix("STRINGS_")).idColumnName("id")).idColumnType("VARCHAR")).dataColumnName("datum")).dataColumnType("BINARY")).timestampColumnName("version")).timestampColumnType("BIGINT")).segmentColumnName("segfault")).segmentColumnType("BIGINT")).async().enable();
        Configuration configuration = b.build();
        JdbcStringBasedStoreConfiguration store = (JdbcStringBasedStoreConfiguration)configuration.persistence().stores().get(0);
        AssertJUnit.assertTrue((boolean)(store.connectionFactory() instanceof PooledConnectionFactoryConfiguration));
        AssertJUnit.assertEquals((String)JDBC_URL, (String)((PooledConnectionFactoryConfiguration)store.connectionFactory()).connectionUrl());
        AssertJUnit.assertEquals((String)"STRINGS_", (String)store.table().tableNamePrefix());
        AssertJUnit.assertEquals((String)"id", (String)store.table().idColumnName());
        AssertJUnit.assertEquals((String)"VARCHAR", (String)store.table().idColumnType());
        AssertJUnit.assertEquals((String)"datum", (String)store.table().dataColumnName());
        AssertJUnit.assertEquals((String)"BINARY", (String)store.table().dataColumnType());
        AssertJUnit.assertEquals((String)"version", (String)store.table().timestampColumnName());
        AssertJUnit.assertEquals((String)"BIGINT", (String)store.table().timestampColumnType());
        AssertJUnit.assertEquals((String)"segfault", (String)store.table().segmentColumnName());
        AssertJUnit.assertEquals((String)"BIGINT", (String)store.table().segmentColumnType());
        AssertJUnit.assertTrue((boolean)store.fetchPersistentState());
        AssertJUnit.assertTrue((boolean)store.async().enabled());
        b = new ConfigurationBuilder();
        ((JdbcStringBasedStoreConfigurationBuilder)b.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).read(store);
        Configuration configuration2 = b.build();
        JdbcStringBasedStoreConfiguration store2 = (JdbcStringBasedStoreConfiguration)configuration2.persistence().stores().get(0);
        AssertJUnit.assertTrue((boolean)(store2.connectionFactory() instanceof PooledConnectionFactoryConfiguration));
        AssertJUnit.assertEquals((String)JDBC_URL, (String)((PooledConnectionFactoryConfiguration)store2.connectionFactory()).connectionUrl());
        AssertJUnit.assertEquals((String)"STRINGS_", (String)store2.table().tableNamePrefix());
        AssertJUnit.assertEquals((String)"id", (String)store2.table().idColumnName());
        AssertJUnit.assertEquals((String)"VARCHAR", (String)store2.table().idColumnType());
        AssertJUnit.assertEquals((String)"datum", (String)store2.table().dataColumnName());
        AssertJUnit.assertEquals((String)"BINARY", (String)store2.table().dataColumnType());
        AssertJUnit.assertEquals((String)"version", (String)store2.table().timestampColumnName());
        AssertJUnit.assertEquals((String)"BIGINT", (String)store2.table().timestampColumnType());
        AssertJUnit.assertEquals((String)"segfault", (String)store2.table().segmentColumnName());
        AssertJUnit.assertEquals((String)"BIGINT", (String)store2.table().segmentColumnType());
        AssertJUnit.assertTrue((boolean)store2.fetchPersistentState());
        AssertJUnit.assertTrue((boolean)store2.async().enabled());
    }

    public void testTableProperties() {
        ConfigurationBuilder b = new ConfigurationBuilder();
        JdbcStringBasedStoreConfigurationBuilder jdbc = (JdbcStringBasedStoreConfigurationBuilder)b.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        UnitTestDatabaseManager.buildTableManipulation(jdbc.table());
        ((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)jdbc.table().createOnStart(false)).dropOnExit(true)).connectionPool().connectionUrl(JDBC_URL);
        Configuration stringConfiguration = b.build();
        JdbcStringBasedStoreConfiguration stringStoreConfiguration = (JdbcStringBasedStoreConfiguration)stringConfiguration.persistence().stores().get(0);
        AssertJUnit.assertFalse((boolean)stringStoreConfiguration.table().createOnStart());
        AssertJUnit.assertTrue((boolean)stringStoreConfiguration.table().dropOnExit());
    }
}

