/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stringbased;

import java.lang.reflect.Method;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.test.ExceptionRunnable;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.stringbased.JdbcStringBasedStoreFunctionalTest;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="persistence.jdbc.stringbased.JdbcStringBasedStoreTxFunctionalTest")
public class JdbcStringBasedStoreTxFunctionalTest
extends JdbcStringBasedStoreFunctionalTest {
    private boolean transactionalConfig;
    private boolean sharedConfig;

    @Factory
    public Object[] factory() {
        return new Object[]{new JdbcStringBasedStoreTxFunctionalTest().transactionalConfig(true).sharedConfig(false), new JdbcStringBasedStoreTxFunctionalTest().transactionalConfig(false).sharedConfig(false), new JdbcStringBasedStoreTxFunctionalTest().transactionalConfig(true).sharedConfig(true), new JdbcStringBasedStoreTxFunctionalTest().transactionalConfig(false).sharedConfig(true)};
    }

    protected String parameters() {
        return " [transactionalConfig=" + this.transactionalConfig + ", sharedConfig=" + this.sharedConfig + "]";
    }

    private JdbcStringBasedStoreTxFunctionalTest transactionalConfig(boolean transactionalConfig) {
        this.transactionalConfig = transactionalConfig;
        return this;
    }

    private JdbcStringBasedStoreTxFunctionalTest sharedConfig(boolean sharedConfig) {
        this.sharedConfig = sharedConfig;
        return this;
    }

    protected ConfigurationBuilder getDefaultCacheConfiguration() {
        ConfigurationBuilder configurationBuilder = super.getDefaultCacheConfiguration();
        configurationBuilder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        if (this.sharedConfig) {
            configurationBuilder.clustering().cacheMode(CacheMode.REPL_SYNC);
        }
        return configurationBuilder;
    }

    @Override
    protected void modifyJdbcConfiguration(JdbcStringBasedStoreConfigurationBuilder builder) {
        builder.transactional(this.transactionalConfig);
        builder.shared(this.sharedConfig);
    }

    protected EmbeddedCacheManager createCacheManager(boolean start, GlobalConfigurationBuilder global, ConfigurationBuilder cb) {
        if (this.transactionalConfig) {
            cb.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        }
        if (this.sharedConfig) {
            ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder(Thread.currentThread().getContextClassLoader(), global);
            if (cb != null) {
                String defaultName = JdbcStringBasedStoreTxFunctionalTest.class.getName() + "-default";
                global.defaultCacheName(defaultName);
                holder.newConfigurationBuilder(defaultName).read(cb.build());
            }
            global.transport().defaultTransport();
            return TestCacheManagerFactory.createClusteredCacheManager((boolean)start, (ConfigurationBuilderHolder)holder);
        }
        return super.createCacheManager(start, global, cb);
    }

    public void testRemoveCacheWithPassivation() {
        if (!this.sharedConfig && !this.transactionalConfig) {
            super.testRemoveCacheWithPassivation();
        }
    }

    public void testStoreByteArrays(Method m) throws PersistenceException {
        if (!this.sharedConfig && !this.transactionalConfig) {
            super.testStoreByteArrays(m);
        }
    }

    public void testWithPassivation(Method m) throws Exception {
        ConfigurationBuilder base = this.getDefaultCacheConfiguration();
        base.persistence().passivation(true);
        ExceptionRunnable runnable = () -> TestingUtil.defineConfiguration((EmbeddedCacheManager)this.cacheManager, (String)m.getName(), (Configuration)this.configureCacheLoader(base, m.getName(), false).build());
        if (this.transactionalConfig || this.sharedConfig) {
            Exceptions.expectException(CacheConfigurationException.class, (ExceptionRunnable)runnable);
        } else {
            runnable.run();
        }
    }

    public void testWithPurgeOnStartup(Method m) throws Exception {
        ConfigurationBuilder base = this.getDefaultCacheConfiguration();
        ExceptionRunnable runnable = () -> TestingUtil.defineConfiguration((EmbeddedCacheManager)this.cacheManager, (String)m.getName(), (Configuration)this.configureCacheLoader(base, m.getName(), true).build());
        if (this.sharedConfig) {
            Exceptions.expectException(CacheConfigurationException.class, (ExceptionRunnable)runnable);
        } else {
            runnable.run();
        }
    }

    public void testRollback() throws SystemException, NotSupportedException {
        String cacheName = "testRollback";
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        this.createCacheStoreConfig(cb.persistence(), cacheName, false);
        TestingUtil.defineConfiguration((EmbeddedCacheManager)this.cacheManager, (String)cacheName, (Configuration)cb.build());
        Cache cache = this.cacheManager.getCache(cacheName);
        String key = "rollback-test";
        AssertJUnit.assertNull((Object)cache.get((Object)key));
        TransactionManager manager = cache.getAdvancedCache().getTransactionManager();
        String value = "the-value";
        manager.begin();
        cache.put((Object)key, (Object)value);
        AssertJUnit.assertEquals((Object)value, (Object)cache.get((Object)key));
        manager.rollback();
        AssertJUnit.assertNull((Object)cache.get((Object)key));
    }
}

