/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.stringbased;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.io.ByteBuffer;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.LockSupportCacheStore;
import org.infinispan.loaders.jdbc.JdbcUtil;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStoreConfig;
import org.infinispan.loaders.jdbc.stringbased.Key2StringMapper;
import org.infinispan.loaders.jdbc.stringbased.UnsupportedKeyTypeException;
import org.infinispan.marshall.Marshaller;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcStringBasedCacheStore
extends LockSupportCacheStore {
    private static Log log = LogFactory.getLog(JdbcStringBasedCacheStore.class);
    private static final byte STRING_STREAM_DELIMITER = 100;
    private JdbcStringBasedCacheStoreConfig config;
    private Key2StringMapper key2StringMapper;
    private ConnectionFactory connectionFactory;
    private TableManipulation tableManipulation;

    public void init(CacheLoaderConfig config, Cache cache, Marshaller m) {
        super.init(config, cache, m);
        this.config = (JdbcStringBasedCacheStoreConfig)config;
    }

    public void start() throws CacheLoaderException {
        super.start();
        if (this.config.isManageConnectionFactory()) {
            String connectionFactoryClass = this.config.getConnectionFactoryConfig().getConnectionFactoryClass();
            ConnectionFactory connectionFactory = ConnectionFactory.getConnectionFactory(connectionFactoryClass);
            connectionFactory.start(this.config.getConnectionFactoryConfig());
            this.doConnectionFactoryInitialization(connectionFactory);
        }
        this.key2StringMapper = this.config.getKey2StringMapper();
    }

    public void stop() throws CacheLoaderException {
        this.tableManipulation.stop();
        if (this.config.isManageConnectionFactory()) {
            this.connectionFactory.stop();
        }
    }

    protected String getLockFromKey(Object key) throws CacheLoaderException {
        if (!this.key2StringMapper.isSupportedType(key.getClass())) {
            throw new UnsupportedKeyTypeException(key);
        }
        return this.key2StringMapper.getStringMapping(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeLockSafe(InternalCacheEntry ed, String lockingKey) throws CacheLoaderException {
        InternalCacheEntry existingOne = this.loadLockSafe(ed, lockingKey);
        String sql = existingOne == null ? this.tableManipulation.getInsertRowSql() : this.tableManipulation.getUpdateRowSql();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Running sql '" + sql + "' on " + ed + ". Key string is '" + lockingKey + "'"));
        }
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.connectionFactory.getConnection();
            ps = connection.prepareStatement(sql);
            ByteBuffer byteBuffer = JdbcUtil.marshall(this.getMarshaller(), ed.toInternalCacheValue());
            ps.setBinaryStream(1, byteBuffer.getStream(), byteBuffer.getLength());
            ps.setLong(2, ed.getExpiryTime());
            ps.setString(3, lockingKey);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                this.logAndThrow(ex, "Error while storing string keys to database");
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(connection);
                throw throwable;
            }
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(connection);
        }
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(connection);
    }

    public boolean removeLockSafe(Object key, String keyStr) throws CacheLoaderException {
        boolean bl;
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            String sql = this.tableManipulation.getDeleteRowSql();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Running sql '" + sql + "' on " + keyStr));
            }
            connection = this.connectionFactory.getConnection();
            ps = connection.prepareStatement(sql);
            ps.setString(1, keyStr);
            bl = ps.executeUpdate() == 1;
        }
        catch (SQLException ex) {
            try {
                String message = "Error while storing string keys to database";
                log.error((Object)message, (Throwable)ex);
                throw new CacheLoaderException(message, (Throwable)ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(connection);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(connection);
        return bl;
    }

    /*
     * Exception decompiling
     */
    public void fromStreamLockSafe(ObjectInput objectInput) throws CacheLoaderException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void toStreamLockSafe(ObjectOutput objectOutput) throws CacheLoaderException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = this.tableManipulation.getLoadAllRowsSql();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Running sql '" + sql));
            }
            connection = this.connectionFactory.getConnection();
            ps = connection.prepareStatement(sql);
            rs = ps.executeQuery();
            rs.setFetchSize(this.config.getFetchSize());
            while (rs.next()) {
                InputStream is = rs.getBinaryStream(1);
                InternalCacheValue icv = (InternalCacheValue)JdbcUtil.unmarshall(this.getMarshaller(), is);
                Object key = rs.getObject(2);
                this.marshaller.objectToObjectStream((Object)icv.toInternalCacheEntry(key), objectOutput);
            }
            this.marshaller.objectToObjectStream((Object)100, objectOutput);
        }
        catch (SQLException e) {
            this.logAndThrow(e, "SQL Error while storing string keys to database");
            JdbcUtil.safeClose(rs);
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(connection);
        }
        catch (IOException e2) {
            this.logAndThrow(e2, "I/O Error while storing string keys to database");
            {
                catch (Throwable throwable) {
                    JdbcUtil.safeClose(rs);
                    JdbcUtil.safeClose(ps);
                    this.connectionFactory.releaseConnection(connection);
                    throw throwable;
                }
            }
            JdbcUtil.safeClose(rs);
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(connection);
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearLockSafe() throws CacheLoaderException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            String sql = this.tableManipulation.getDeleteAllRowsSql();
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            int result = ps.executeUpdate();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Successfully removed " + result + " rows."));
            }
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
        }
        catch (SQLException ex) {
            this.logAndThrow(ex, "Failed clearing JdbcBinaryCacheStore");
        }
        finally {
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeInternal() throws CacheLoaderException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            String sql = this.tableManipulation.getDeleteExpiredRowsSql();
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setLong(1, System.currentTimeMillis());
            int result = ps.executeUpdate();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Successfully purged " + result + " rows."));
            }
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
        }
        catch (SQLException ex) {
            this.logAndThrow(ex, "Failed purging JdbcBinaryCacheStore");
        }
        finally {
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
        }
    }

    protected Set<InternalCacheEntry> loadAllLockSafe() throws CacheLoaderException {
        HashSet<InternalCacheEntry> hashSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = this.tableManipulation.getLoadAllRowsSql();
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            rs.setFetchSize(this.config.getFetchSize());
            HashSet<InternalCacheEntry> result = new HashSet<InternalCacheEntry>();
            while (rs.next()) {
                InputStream inputStream = rs.getBinaryStream(1);
                InternalCacheValue icv = (InternalCacheValue)JdbcUtil.unmarshall(this.getMarshaller(), inputStream);
                Object key = rs.getObject(2);
                result.add(icv.toInternalCacheEntry(key));
            }
            hashSet = result;
        }
        catch (SQLException e) {
            try {
                String message = "SQL error while fetching all StoredEntries";
                log.error((Object)message, (Throwable)e);
                throw new CacheLoaderException(message, (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
        return hashSet;
    }

    protected InternalCacheEntry loadLockSafe(Object key, String lockingKey) throws CacheLoaderException {
        InternalCacheEntry inputStream2;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block7: {
            InternalCacheEntry storedEntry;
            block8: {
                conn = null;
                ps = null;
                rs = null;
                String sql = this.tableManipulation.getSelectRowSql();
                conn = this.connectionFactory.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, lockingKey);
                rs = ps.executeQuery();
                if (!rs.next()) break block7;
                InputStream inputStream2 = rs.getBinaryStream(2);
                InternalCacheValue icv = (InternalCacheValue)JdbcUtil.unmarshall(this.getMarshaller(), inputStream2);
                storedEntry = icv.toInternalCacheEntry(key);
                if (!storedEntry.isExpired()) break block8;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Not returning '" + storedEntry + "' as it is expired. It will be removed from DB by purging thread!"));
                }
                InternalCacheEntry internalCacheEntry = null;
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                return internalCacheEntry;
            }
            InternalCacheEntry internalCacheEntry = storedEntry;
            JdbcUtil.safeClose(rs);
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
            return internalCacheEntry;
        }
        try {
            inputStream2 = null;
        }
        catch (SQLException e) {
            try {
                String message = "SQL error while fetching strored entry with key:" + key + " lockingKey: " + lockingKey;
                log.error((Object)message, (Throwable)e);
                throw new CacheLoaderException(message, (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
        return inputStream2;
    }

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return JdbcStringBasedCacheStoreConfig.class;
    }

    protected void logAndThrow(Exception e, String message) throws CacheLoaderException {
        log.error((Object)message, (Throwable)e);
        throw new CacheLoaderException(message, (Throwable)e);
    }

    public boolean supportsKey(Class keyType) {
        return this.key2StringMapper.isSupportedType(keyType);
    }

    public void doConnectionFactoryInitialization(ConnectionFactory connectionFactory) throws CacheLoaderException {
        this.connectionFactory = connectionFactory;
        this.tableManipulation = this.config.getTableManipulation();
        this.tableManipulation.start(connectionFactory);
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }
}

