/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.mixed;

import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStoreConfig;
import org.infinispan.loaders.jdbc.stringbased.PersonKey2StringMapper;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.jdbc.mixed.JdbcMixedCacheStoreConfigTest")
public class JdbcMixedCacheStoreConfigTest {
    private JdbcMixedCacheStoreConfig config;

    @BeforeMethod
    public void createConfig() {
        this.config = new JdbcMixedCacheStoreConfig();
    }

    public void simpleTest() {
        this.config = new JdbcMixedCacheStoreConfig();
        this.config.setConnectionUrl("url");
        this.config.setCreateTableOnStartForBinary(false);
        this.config.setCreateTableOnStartForStrings(true);
        this.config.setDataColumnNameForBinary("binary_dc");
        this.config.setDataColumnNameForStrings("strings_dc");
        this.config.setDataColumnTypeForBinary("binary_dct");
        this.config.setDataColumnTypeForStrings("strings_dct");
        this.config.setDriverClass("driver");
        assert (!this.config.getBinaryCacheStoreConfig().getTableManipulation().isCreateTableOnStart());
        assert (this.config.getStringCacheStoreConfig().getTableManipulation().isCreateTableOnStart());
        assert (this.config.getConnectionFactoryConfig().getDriverClass().equals("driver"));
        assert (this.config.getBinaryCacheStoreConfig().getTableManipulation().getDataColumnName().equals("binary_dc"));
        assert (this.config.getBinaryCacheStoreConfig().getTableManipulation().getDataColumnType().equals("binary_dct"));
        assert (this.config.getStringCacheStoreConfig().getTableManipulation().getDataColumnName().equals("strings_dc"));
        assert (this.config.getStringCacheStoreConfig().getTableManipulation().getDataColumnType().equals("strings_dct"));
    }

    public void testSameTableName() {
        this.config.setTableNameForBinary("table");
        try {
            this.config.setTableNameForStrings("table");
            assert (false) : "expection expected as same table name is not allowed for both cache stores";
        }
        catch (Exception e) {
            // empty catch block
        }
        this.config.setTableNameForStrings("table2");
        try {
            this.config.setTableNameForBinary("table2");
            assert (false) : "expection expected as same table name is not allowed for both cache stores";
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testKey2StringMapper() {
        this.config.setKey2StringMapperClass(PersonKey2StringMapper.class.getName());
        assert (this.config.getStringCacheStoreConfig().getKey2StringMapper().getClass().equals(PersonKey2StringMapper.class));
    }

    public void testConcurrencyLevel() {
        assert (this.config.getStringCacheStoreConfig().getLockConcurrencyLevel() == 1024);
        assert (this.config.getBinaryCacheStoreConfig().getLockConcurrencyLevel() == 1024);
        this.config.setLockConcurrencyLevelForStrings(11);
        this.config.setLockConcurrencyLevelForBinary(12);
        assert (this.config.getStringCacheStoreConfig().getLockConcurrencyLevel() == 11);
        assert (this.config.getBinaryCacheStoreConfig().getLockConcurrencyLevel() == 12);
    }

    public void testEnforcedSyncPurging() {
        assert (this.config.getBinaryCacheStoreConfig().isPurgeSynchronously());
        assert (this.config.getStringCacheStoreConfig().isPurgeSynchronously());
    }

    public void voidTestLockAquisitionTimeout() {
        assert (this.config.getStringCacheStoreConfig().getLockAcquistionTimeout() == 60000L);
        assert (this.config.getBinaryCacheStoreConfig().getLockAcquistionTimeout() == 60000L);
        this.config.setLockAcquistionTimeout(13);
        assert (this.config.getStringCacheStoreConfig().getLockAcquistionTimeout() == 13L);
        assert (this.config.getBinaryCacheStoreConfig().getLockAcquistionTimeout() == 13L);
    }
}

