/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.mixed;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Set;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStore;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStoreConfig;
import org.infinispan.loaders.jdbc.stringbased.DefaultKey2StringMapper;
import org.infinispan.loaders.jdbc.stringbased.Person;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.mixed.JdbcMixedCacheStoreTest")
public class JdbcMixedCacheStoreTest {
    private CacheStore cacheStore;
    private TableManipulation stringsTm;
    private TableManipulation binaryTm;
    private ConnectionFactoryConfig cfc;
    private static final Person MIRCEA = new Person("Mircea", "Markus", 28);
    private static final Person MANIK = new Person("Manik", "Surtani", 18);

    @BeforeTest
    public void createCacheStore() throws CacheLoaderException {
        this.stringsTm = UnitTestDatabaseManager.buildDefaultTableManipulation();
        this.stringsTm.setTableName("STRINGS_TABLE");
        this.binaryTm = UnitTestDatabaseManager.buildDefaultTableManipulation();
        this.binaryTm.setTableName("BINARY_TABLE");
        this.cfc = UnitTestDatabaseManager.getUniqueConnectionFactoryConfig();
        JdbcMixedCacheStoreConfig cacheStoreConfig = new JdbcMixedCacheStoreConfig(this.cfc, this.binaryTm, this.stringsTm);
        cacheStoreConfig.setPurgeSynchronously(true);
        cacheStoreConfig.setKey2StringMapperClass(DefaultKey2StringMapper.class.getName());
        this.cacheStore = new JdbcMixedCacheStore();
        this.cacheStore.init((CacheLoaderConfig)cacheStoreConfig, null, (Marshaller)new TestObjectStreamMarshaller(true));
        this.cacheStore.start();
    }

    @AfterMethod
    public void clearStore() throws Exception {
        this.cacheStore.clear();
        this.assertBinaryRowCount(0);
        this.assertStringsRowCount(0);
    }

    @AfterTest
    public void destroyStore() throws CacheLoaderException {
        this.cacheStore.stop();
        UnitTestDatabaseManager.shutdownInMemoryDatabase(this.cfc);
    }

    public void testMixedStore() throws Exception {
        this.cacheStore.store(InternalEntryFactory.create((Object)"String", (Object)"someValue"));
        this.assertStringsRowCount(1);
        this.assertBinaryRowCount(0);
        this.cacheStore.store(InternalEntryFactory.create((Object)MIRCEA, (Object)"value"));
        this.assertStringsRowCount(1);
        this.assertStringsRowCount(1);
        assert (this.cacheStore.load((Object)MIRCEA).getValue().equals("value"));
        assert (this.cacheStore.load((Object)"String").getValue().equals("someValue"));
    }

    public void testMultipleEntriesWithSameHashCode() throws Exception {
        Person one = new Person("Mircea", "Markus", 28);
        Person two = new Person("Manik", "Surtani", 28);
        one.setHashCode(100);
        two.setHashCode(100);
        this.cacheStore.store(InternalEntryFactory.create((Object)one, (Object)"value"));
        this.assertBinaryRowCount(1);
        this.assertStringsRowCount(0);
        this.cacheStore.store(InternalEntryFactory.create((Object)two, (Object)"otherValue"));
        this.assertBinaryRowCount(1);
        this.assertStringsRowCount(0);
        assert (this.cacheStore.load((Object)one).getValue().equals("value"));
        assert (this.cacheStore.load((Object)two).getValue().equals("otherValue"));
    }

    public void testClear() throws Exception {
        this.cacheStore.store(InternalEntryFactory.create((Object)"String", (Object)"someValue"));
        this.assertRowCounts(0, 1);
        this.cacheStore.store(InternalEntryFactory.create((Object)MIRCEA, (Object)"value"));
        this.assertRowCounts(1, 1);
        this.cacheStore.clear();
        this.assertRowCounts(0, 0);
    }

    public void testMixedFromAndToStream() throws Exception {
        this.cacheStore.store(InternalEntryFactory.create((Object)"String", (Object)"someValue"));
        this.cacheStore.store(InternalEntryFactory.create((Object)"String2", (Object)"someValue"));
        this.cacheStore.store(InternalEntryFactory.create((Object)MIRCEA, (Object)"value1"));
        this.cacheStore.store(InternalEntryFactory.create((Object)MANIK, (Object)"value2"));
        this.assertRowCounts(2, 2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        this.cacheStore.toStream((ObjectOutput)objectOutputStream);
        this.cacheStore.clear();
        this.assertRowCounts(0, 0);
        this.cacheStore.fromStream((ObjectInput)new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
        this.assertRowCounts(2, 2);
        assert (this.cacheStore.load((Object)"String").getValue().equals("someValue"));
        assert (this.cacheStore.load((Object)"String2").getValue().equals("someValue"));
        assert (this.cacheStore.load((Object)MIRCEA).getValue().equals("value1"));
        assert (this.cacheStore.load((Object)MANIK).getValue().equals("value2"));
    }

    public void testLoadAll() throws Exception {
        InternalCacheEntry first = InternalEntryFactory.create((Object)"String", (Object)"someValue");
        InternalCacheEntry second = InternalEntryFactory.create((Object)"String2", (Object)"someValue");
        InternalCacheEntry third = InternalEntryFactory.create((Object)MIRCEA, (Object)"value1");
        InternalCacheEntry forth = InternalEntryFactory.create((Object)MANIK, (Object)"value2");
        this.cacheStore.store(first);
        this.cacheStore.store(second);
        this.cacheStore.store(third);
        this.cacheStore.store(forth);
        this.assertRowCounts(2, 2);
        Set entries = this.cacheStore.loadAll();
        assert (entries.size() == 4);
        assert (entries.contains(first));
        assert (entries.contains(second));
        assert (entries.contains(third));
        assert (entries.contains(forth));
    }

    public void testPurgeExpired() throws Exception {
        InternalCacheEntry first = InternalEntryFactory.create((Object)"String", (Object)"someValue", (long)1000L);
        InternalCacheEntry second = InternalEntryFactory.create((Object)MIRCEA, (Object)"value1", (long)1000L);
        this.cacheStore.store(first);
        this.cacheStore.store(second);
        this.assertRowCounts(1, 1);
        Thread.sleep(1200L);
        this.cacheStore.purgeExpired();
        this.assertRowCounts(0, 0);
    }

    public void testPurgeExpiredWithRemainingEntries() throws Exception {
        InternalCacheEntry first = InternalEntryFactory.create((Object)"String", (Object)"someValue", (long)1000L);
        InternalCacheEntry second = InternalEntryFactory.create((Object)"String2", (Object)"someValue");
        InternalCacheEntry third = InternalEntryFactory.create((Object)MIRCEA, (Object)"value1", (long)1000L);
        InternalCacheEntry forth = InternalEntryFactory.create((Object)MANIK, (Object)"value1");
        this.cacheStore.store(first);
        this.cacheStore.store(second);
        this.cacheStore.store(third);
        this.cacheStore.store(forth);
        this.assertRowCounts(2, 2);
        Thread.sleep(1200L);
        this.cacheStore.purgeExpired();
        this.assertRowCounts(1, 1);
    }

    public void testTableConflict() {
    }

    private void assertRowCounts(int binary, int strings) {
        this.assertBinaryRowCount(binary);
        this.assertStringsRowCount(strings);
    }

    private void assertStringsRowCount(int rowCount) {
        JdbcMixedCacheStore store = (JdbcMixedCacheStore)this.cacheStore;
        ConnectionFactory connectionFactory = store.getConnectionFactory();
        String tableName = this.stringsTm.getTableName();
        int value = UnitTestDatabaseManager.rowCount(connectionFactory, tableName);
        assert (value == rowCount) : "Expected " + rowCount + " rows, actual value is " + value;
    }

    private void assertBinaryRowCount(int rowCount) {
        JdbcMixedCacheStore store = (JdbcMixedCacheStore)this.cacheStore;
        ConnectionFactory connectionFactory = store.getConnectionFactory();
        String tableName = this.binaryTm.getTableName();
        int value = UnitTestDatabaseManager.rowCount(connectionFactory, tableName);
        assert (value == rowCount) : "Expected " + rowCount + " rows, actual value is " + value;
    }
}

