/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.stringbased;

import java.util.Collections;
import java.util.HashSet;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStore;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStoreConfig;
import org.infinispan.loaders.jdbc.stringbased.Person;
import org.infinispan.loaders.jdbc.stringbased.PersonKey2StringMapper;
import org.infinispan.loaders.jdbc.stringbased.UnsupportedKeyTypeException;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.stringbased.JdbcStringBasedCacheStoreTest2")
public class JdbcStringBasedCacheStoreTest2 {
    CacheStore cacheStore;
    private ConnectionFactoryConfig cfc;
    private TableManipulation tableManipulation;
    private static final Person MIRCEA = new Person("Mircea", "Markus", 28);
    private static final Person MANIK = new Person("Manik", "Surtani", 18);

    @BeforeTest
    public void createCacheStore() throws CacheLoaderException {
        this.tableManipulation = UnitTestDatabaseManager.buildDefaultTableManipulation();
        this.cfc = UnitTestDatabaseManager.getUniqueConnectionFactoryConfig();
        JdbcStringBasedCacheStoreConfig config = new JdbcStringBasedCacheStoreConfig(this.cfc, this.tableManipulation);
        config.setKey2StringMapperClass(PersonKey2StringMapper.class.getName());
        config.setPurgeSynchronously(true);
        this.cacheStore = new JdbcStringBasedCacheStore();
        this.cacheStore.init((CacheLoaderConfig)config, null, (Marshaller)new TestObjectStreamMarshaller());
        this.cacheStore.start();
    }

    @AfterMethod
    public void clearStore() throws Exception {
        this.cacheStore.clear();
        assert (this.rowCount() == 0);
    }

    @AfterTest
    public void destroyStore() throws CacheLoaderException {
        this.cacheStore.stop();
        UnitTestDatabaseManager.shutdownInMemoryDatabase(this.cfc);
    }

    public void persistUnsupportedObject() throws Exception {
        try {
            this.cacheStore.store(InternalEntryFactory.create((Object)"key", (Object)"value"));
            assert (false) : "exception is expected as PersonKey2StringMapper does not support strings";
        }
        catch (UnsupportedKeyTypeException unsupportedKeyTypeException) {
            // empty catch block
        }
        this.cacheStore.store(InternalEntryFactory.create((Object)MIRCEA, (Object)"Cluj Napoca"));
    }

    public void testStoreLoadRemove() throws Exception {
        assert (this.rowCount() == 0);
        assert (this.cacheStore.load((Object)MIRCEA) == null) : "should not be present in the store";
        String value = "adsdsadsa";
        this.cacheStore.store(InternalEntryFactory.create((Object)MIRCEA, (Object)value));
        assert (this.rowCount() == 1);
        assert (this.cacheStore.load((Object)MIRCEA).getValue().equals(value));
        assert (!this.cacheStore.remove((Object)MANIK));
        assert (this.cacheStore.load((Object)MIRCEA).getValue().equals(value));
        assert (this.rowCount() == 1);
        assert (this.cacheStore.remove((Object)MIRCEA));
        assert (this.rowCount() == 0);
    }

    public void testRemoveAll() throws Exception {
        assert (this.rowCount() == 0);
        this.cacheStore.store(InternalEntryFactory.create((Object)MIRCEA, (Object)"value"));
        this.cacheStore.store(InternalEntryFactory.create((Object)MANIK, (Object)"value"));
        assert (this.rowCount() == 2);
        this.cacheStore.removeAll(Collections.singleton(MIRCEA));
        assert (this.cacheStore.load((Object)MANIK).getValue().equals("value"));
        assert (this.rowCount() == 1);
        this.cacheStore.store(InternalEntryFactory.create((Object)MIRCEA, (Object)"value"));
        assert (this.rowCount() == 2);
        HashSet<Person> toRemove = new HashSet<Person>();
        toRemove.add(MIRCEA);
        toRemove.add(MANIK);
        this.cacheStore.removeAll(toRemove);
        assert (this.rowCount() == 0);
    }

    public void testClear() throws Exception {
        assert (this.rowCount() == 0);
        this.cacheStore.store(InternalEntryFactory.create((Object)MIRCEA, (Object)"value"));
        this.cacheStore.store(InternalEntryFactory.create((Object)MANIK, (Object)"value"));
        assert (this.rowCount() == 2);
        this.cacheStore.clear();
        assert (this.rowCount() == 0);
    }

    public void testPurgeExpired() throws Exception {
        InternalCacheEntry first = InternalEntryFactory.create((Object)MIRCEA, (Object)"val", (long)1000L);
        InternalCacheEntry second = InternalEntryFactory.create((Object)MANIK, (Object)"val2");
        this.cacheStore.store(first);
        this.cacheStore.store(second);
        assert (this.rowCount() == 2);
        Thread.sleep(1100L);
        this.cacheStore.purgeExpired();
        assert (this.rowCount() == 1);
        assert (this.cacheStore.load((Object)MANIK).getValue().equals("val2"));
    }

    private int rowCount() {
        ConnectionFactory connectionFactory = this.getConnection();
        String tableName = this.tableManipulation.getTableName();
        return UnitTestDatabaseManager.rowCount(connectionFactory, tableName);
    }

    private ConnectionFactory getConnection() {
        JdbcStringBasedCacheStore store = (JdbcStringBasedCacheStore)this.cacheStore;
        return store.getConnectionFactory();
    }
}

