/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.binary;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.io.ByteBuffer;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.bucket.Bucket;
import org.infinispan.loaders.bucket.BucketBasedCacheStore;
import org.infinispan.loaders.jdbc.JdbcUtil;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStoreConfig;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.marshall.Marshaller;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcBinaryCacheStore
extends BucketBasedCacheStore {
    private static final Log log = LogFactory.getLog(JdbcBinaryCacheStore.class);
    private static final byte BINARY_STREAM_DELIMITER = 100;
    private JdbcBinaryCacheStoreConfig config;
    private ConnectionFactory connectionFactory;
    private TableManipulation tableManipulation;

    public void init(CacheLoaderConfig config, Cache cache, Marshaller m) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Initializing JdbcBinaryCacheStore " + config));
        }
        super.init(config, cache, m);
        this.config = (JdbcBinaryCacheStoreConfig)config;
    }

    public void start() throws CacheLoaderException {
        super.start();
        String connectionFactoryClass = this.config.getConnectionFactoryConfig().getConnectionFactoryClass();
        if (this.config.isManageConnectionFatory()) {
            ConnectionFactory factory = ConnectionFactory.getConnectionFactory(connectionFactoryClass);
            factory.start(this.config.getConnectionFactoryConfig());
            this.doConnectionFactoryInitialization(factory);
        }
    }

    public void stop() throws CacheLoaderException {
        this.tableManipulation.stop();
        if (this.config.isManageConnectionFatory()) {
            this.connectionFactory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertBucket(Bucket bucket) throws CacheLoaderException {
        PreparedStatement ps;
        Connection conn;
        block5: {
            conn = null;
            ps = null;
            try {
                String sql = this.tableManipulation.getInsertRowSql();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Running insertBucket. Sql: '" + sql + "', on bucket: " + bucket));
                }
                conn = this.connectionFactory.getConnection();
                ps = conn.prepareStatement(sql);
                ByteBuffer byteBuffer = JdbcUtil.marshall(this.getMarshaller(), bucket);
                ps.setBinaryStream(1, byteBuffer.getStream(), byteBuffer.getLength());
                ps.setLong(2, bucket.timestampOfFirstEntryToExpire());
                ps.setString(3, bucket.getBucketName());
                int insertedRows = ps.executeUpdate();
                if (insertedRows == 1) break block5;
                throw new CacheLoaderException("Unexpected insert result: '" + insertedRows + "'. Expected values is 1");
            }
            catch (SQLException ex) {
                try {
                    this.logAndThrow(ex, "sql failure while inserting bucket: " + bucket);
                }
                catch (Throwable throwable) {
                    JdbcUtil.safeClose(ps);
                    this.connectionFactory.releaseConnection(conn);
                    throw throwable;
                }
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
            }
        }
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveBucket(Bucket bucket) throws CacheLoaderException {
        PreparedStatement ps;
        Connection conn;
        block5: {
            conn = null;
            ps = null;
            try {
                String sql = this.tableManipulation.getUpdateRowSql();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Running saveBucket. Sql: '" + sql + "', on bucket: " + bucket));
                }
                conn = this.connectionFactory.getConnection();
                ps = conn.prepareStatement(sql);
                ByteBuffer buffer = JdbcUtil.marshall(this.getMarshaller(), bucket);
                ps.setBinaryStream(1, buffer.getStream(), buffer.getLength());
                ps.setLong(2, bucket.timestampOfFirstEntryToExpire());
                ps.setString(3, bucket.getBucketName());
                int updatedRows = ps.executeUpdate();
                if (updatedRows == 1) break block5;
                throw new CacheLoaderException("Unexpected  update result: '" + updatedRows + "'. Expected values is 1");
            }
            catch (SQLException e) {
                try {
                    this.logAndThrow(e, "sql failure while updating bucket: " + bucket);
                }
                catch (Throwable throwable) {
                    JdbcUtil.safeClose(ps);
                    this.connectionFactory.releaseConnection(conn);
                    throw throwable;
                }
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
            }
        }
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
    }

    protected Bucket loadBucket(String keyHashCode) throws CacheLoaderException {
        Bucket bucket;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            rs = null;
            String sql = this.tableManipulation.getSelectRowSql();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Running loadBucket. Sql: '" + sql + "', on key: " + keyHashCode));
            }
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, keyHashCode);
            rs = ps.executeQuery();
            if (rs.next()) break block6;
            Bucket bucket2 = null;
            JdbcUtil.safeClose(rs);
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
            return bucket2;
        }
        try {
            String bucketName = rs.getString(1);
            InputStream inputStream = rs.getBinaryStream(2);
            Bucket bucket3 = (Bucket)JdbcUtil.unmarshall(this.getMarshaller(), inputStream);
            bucket3.setBucketName(bucketName);
            bucket = bucket3;
        }
        catch (SQLException e) {
            try {
                String message = "sql failure while loading key: " + keyHashCode;
                log.error((Object)message, (Throwable)e);
                throw new CacheLoaderException(message, (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
        return bucket;
    }

    public Set<InternalCacheEntry> loadAllLockSafe() throws CacheLoaderException {
        HashSet<InternalCacheEntry> hashSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = this.tableManipulation.getLoadAllRowsSql();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Running loadAll. Sql: '" + sql + "'"));
            }
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            rs.setFetchSize(this.config.getFetchSize());
            HashSet<InternalCacheEntry> result = new HashSet<InternalCacheEntry>();
            while (rs.next()) {
                InputStream binaryStream = rs.getBinaryStream(1);
                Bucket bucket = (Bucket)JdbcUtil.unmarshall(this.getMarshaller(), binaryStream);
                result.addAll(bucket.getStoredEntries());
            }
            hashSet = result;
        }
        catch (SQLException e) {
            try {
                String message = "sql failure while loading key: ";
                log.error((Object)message, (Throwable)e);
                throw new CacheLoaderException(message, (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
        return hashSet;
    }

    /*
     * Exception decompiling
     */
    protected void fromStreamLockSafe(ObjectInput objectInput) throws CacheLoaderException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void toStreamLockSafe(ObjectOutput objectOutput) throws CacheLoaderException {
        block8: {
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                conn = this.connectionFactory.getConnection();
                String sql = this.tableManipulation.getLoadAllRowsSql();
                ps = conn.prepareStatement(sql);
                rs = ps.executeQuery();
                rs.setFetchSize(this.config.getFetchSize());
                while (rs.next()) {
                    InputStream inputStream = rs.getBinaryStream(1);
                    Bucket bucket = (Bucket)JdbcUtil.unmarshall(this.getMarshaller(), inputStream);
                    String bucketName = rs.getString(2);
                    this.marshaller.objectToObjectStream((Object)bucketName, objectOutput);
                    this.marshaller.objectToObjectStream((Object)bucket, objectOutput);
                }
                this.marshaller.objectToObjectStream((Object)100, objectOutput);
                JdbcUtil.safeClose(rs);
            }
            catch (SQLException ex) {
                this.logAndThrow(ex, "SQL failure while writing store's content to stream");
                break block8;
            }
            catch (IOException e) {
                this.logAndThrow(e, "IO failure while writing store's content to stream");
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
            }
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearLockSafe() throws CacheLoaderException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            String sql = this.tableManipulation.getDeleteAllRowsSql();
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            int result = ps.executeUpdate();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Successfully removed " + result + " rows."));
            }
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
        }
        catch (SQLException ex) {
            this.logAndThrow(ex, "Failed clearing JdbcBinaryCacheStore");
        }
        finally {
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeInternal() throws CacheLoaderException {
        String sql;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<Bucket> expiredBuckets = new HashSet<Bucket>();
        int batchSize = 100;
        try {
            String sql2 = this.tableManipulation.getSelectExpiredRowsSql();
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql2);
            ps.setLong(1, System.currentTimeMillis());
            rs = ps.executeQuery();
            while (rs.next()) {
                String key = rs.getString(2);
                if (this.immediateLockForWriting(key)) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Adding bucket keyed " + key + " for purging."));
                    }
                    InputStream binaryStream = rs.getBinaryStream(1);
                    Bucket bucket = (Bucket)JdbcUtil.unmarshall(this.getMarshaller(), binaryStream);
                    bucket.setBucketName(key);
                    expiredBuckets.add(bucket);
                    continue;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Could not acquire write lock for " + key + ", this won't be purged even though it has expired elements"));
            }
        }
        catch (SQLException ex) {
            try {
                this.releaseLocks(expiredBuckets);
                this.connectionFactory.releaseConnection(conn);
                this.logAndThrow(ex, "Failed clearing JdbcBinaryCacheStore");
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(ps);
                JdbcUtil.safeClose(rs);
                throw throwable;
            }
            JdbcUtil.safeClose(ps);
            JdbcUtil.safeClose(rs);
        }
        JdbcUtil.safeClose(ps);
        JdbcUtil.safeClose(rs);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Found following buckets: " + expiredBuckets + " which are about to be expired"));
        }
        if (expiredBuckets.isEmpty()) {
            return;
        }
        HashSet<Bucket> emptyBuckets = new HashSet<Bucket>();
        try {
            sql = this.tableManipulation.getUpdateRowSql();
            ps = conn.prepareStatement(sql);
            int updateCount = 0;
            Iterator it = expiredBuckets.iterator();
            while (it.hasNext()) {
                Bucket bucket = (Bucket)it.next();
                bucket.removeExpiredEntries();
                if (!bucket.isEmpty()) {
                    ByteBuffer byteBuffer = JdbcUtil.marshall(this.getMarshaller(), bucket);
                    ps.setBinaryStream(1, byteBuffer.getStream(), byteBuffer.getLength());
                    ps.setLong(2, bucket.timestampOfFirstEntryToExpire());
                    ps.addBatch();
                    if (++updateCount % 100 != 0) continue;
                    ps.executeBatch();
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("Flushing batch, update count is: " + updateCount));
                    continue;
                }
                it.remove();
                emptyBuckets.add(bucket);
            }
            if (updateCount % 100 != 0) {
                ps.executeBatch();
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Updated " + updateCount + " buckets."));
            }
        }
        catch (SQLException ex) {
            this.releaseLocks(emptyBuckets);
            this.connectionFactory.releaseConnection(conn);
            this.logAndThrow(ex, "Failed clearing JdbcBinaryCacheStore");
        }
        finally {
            this.releaseLocks(expiredBuckets);
            JdbcUtil.safeClose(ps);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("About to remove empty buckets " + emptyBuckets));
        }
        if (emptyBuckets.isEmpty()) {
            return;
        }
        try {
            sql = this.tableManipulation.getDeleteRowSql();
            ps = conn.prepareStatement(sql);
            int deletionCount = 0;
            for (Bucket bucket : emptyBuckets) {
                ps.setString(1, bucket.getBucketName());
                ps.addBatch();
                if (++deletionCount % 100 != 0) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Flushing deletion batch, total deletion count so far is " + deletionCount));
                }
                ps.executeBatch();
            }
            if (deletionCount % 100 != 0) {
                int[] batchResult = ps.executeBatch();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Flushed the batch and received following results: " + Arrays.toString(batchResult)));
                }
            }
        }
        catch (SQLException ex) {
            this.logAndThrow(ex, "Failed clearing JdbcBinaryCacheStore");
        }
        finally {
            this.releaseLocks(emptyBuckets);
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
        }
    }

    private void releaseLocks(Set<Bucket> expiredBucketKeys) throws CacheLoaderException {
        for (Bucket bucket : expiredBucketKeys) {
            this.unlock(bucket.getBucketName());
        }
    }

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return JdbcBinaryCacheStoreConfig.class;
    }

    protected void logAndThrow(Exception e, String message) throws CacheLoaderException {
        log.error((Object)message, (Throwable)e);
        throw new CacheLoaderException(message, (Throwable)e);
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void doConnectionFactoryInitialization(ConnectionFactory connectionFactory) throws CacheLoaderException {
        this.connectionFactory = connectionFactory;
        this.tableManipulation = this.config.getTableManipulation();
        this.tableManipulation.start(connectionFactory);
    }
}

