/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.stringbased;

import org.infinispan.loaders.LockSupportCacheStoreConfig;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.stringbased.DefaultKey2StringMapper;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStore;
import org.infinispan.loaders.jdbc.stringbased.Key2StringMapper;
import org.infinispan.util.Util;

public class JdbcStringBasedCacheStoreConfig
extends LockSupportCacheStoreConfig {
    private Key2StringMapper key2StringMapper;
    private ConnectionFactoryConfig connectionFactoryConfig = new ConnectionFactoryConfig();
    private TableManipulation tableManipulation = new TableManipulation();
    private boolean manageConnectionFactory = true;

    public JdbcStringBasedCacheStoreConfig(ConnectionFactoryConfig connectionFactoryConfig, TableManipulation tableManipulation) {
        this();
        this.connectionFactoryConfig = connectionFactoryConfig;
        this.tableManipulation = tableManipulation;
    }

    public JdbcStringBasedCacheStoreConfig() {
        this.cacheLoaderClassName = JdbcStringBasedCacheStore.class.getName();
    }

    public JdbcStringBasedCacheStoreConfig(boolean manageConnectionFactory) {
        this();
        this.manageConnectionFactory = manageConnectionFactory;
    }

    public Key2StringMapper getKey2StringMapper() {
        if (this.key2StringMapper == null) {
            try {
                this.key2StringMapper = (Key2StringMapper)DefaultKey2StringMapper.class.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("This should never happen", e);
            }
        }
        return this.key2StringMapper;
    }

    public void setKey2StringMapperClass(String className) {
        this.testImmutability("key2StringMapper");
        try {
            this.key2StringMapper = (Key2StringMapper)Util.getInstance((String)className);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not load Key2StringMapper :'" + className + "'", e);
        }
    }

    public void setStringsTableName(String stringsTableName) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setTableName(stringsTableName);
    }

    public void setIdColumnName(String idColumnName) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setIdColumnName(idColumnName);
    }

    public void setDataColumnName(String dataColumnName) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setDataColumnName(dataColumnName);
    }

    public void setTimestampColumnName(String timestampColumnName) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setTimestampColumnName(timestampColumnName);
    }

    public void setConnectionFactoryClass(String connectionFactoryClass) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setConnectionFactoryClass(connectionFactoryClass);
    }

    public ConnectionFactoryConfig getConnectionFactoryConfig() {
        return this.connectionFactoryConfig;
    }

    public TableManipulation getTableManipulation() {
        return this.tableManipulation;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setConnectionUrl(connectionUrl);
    }

    public void setUserName(String userName) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setUserName(userName);
    }

    public void setPassword(String password) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setPassword(password);
    }

    public void setDriverClass(String driverClassName) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setDriverClass(driverClassName);
    }

    public void setIdColumnType(String idColumnType) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setIdColumnType(idColumnType);
    }

    public void setDataColumnType(String dataColumnType) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setDataColumnType(dataColumnType);
    }

    public void setDropTableOnExit(boolean dropTableOnExit) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setDropTableOnExit(dropTableOnExit);
    }

    public void setCreateTableOnStart(boolean createTableOnStart) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setCreateTableOnStart(createTableOnStart);
    }

    boolean isManageConnectionFactory() {
        return this.manageConnectionFactory;
    }

    public void setTableManipulation(TableManipulation tableManipulation) {
        this.testImmutability("tableManipulation");
        this.tableManipulation = tableManipulation;
    }

    public void setFetchSize(int fetchSize) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setFetchSize(fetchSize);
    }

    public void setBatchSize(int batchSize) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setBatchSize(batchSize);
    }

    public int getFetchSize() {
        return this.tableManipulation.getFetchSize();
    }

    public int getBatchSize() {
        return this.tableManipulation.getBatchSize();
    }
}

