/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.binary;

import org.infinispan.config.ConfigurationElement;
import org.infinispan.config.ConfigurationElements;
import org.infinispan.config.ConfigurationProperty;
import org.infinispan.loaders.LockSupportCacheStoreConfig;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStore;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;

@ConfigurationElements(elements={@ConfigurationElement(name="loader", parent="loaders", description="org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStore", cardinalityInParent=ConfigurationElement.Cardinality.UNBOUNDED), @ConfigurationElement(name="properties", parent="loader")})
public class JdbcBinaryCacheStoreConfig
extends LockSupportCacheStoreConfig {
    private ConnectionFactoryConfig connectionFactoryConfig = new ConnectionFactoryConfig();
    private TableManipulation tableManipulation = new TableManipulation();
    private boolean createConnectionFatory = true;

    public JdbcBinaryCacheStoreConfig(boolean createConnectionFatory) {
        this.createConnectionFatory = createConnectionFatory;
    }

    public JdbcBinaryCacheStoreConfig(ConnectionFactoryConfig connectionFactoryConfig, TableManipulation tm) {
        this();
        this.connectionFactoryConfig = connectionFactoryConfig;
        this.tableManipulation = tm;
    }

    public JdbcBinaryCacheStoreConfig() {
        this.cacheLoaderClassName = JdbcBinaryCacheStore.class.getName();
    }

    boolean isManageConnectionFatory() {
        return this.createConnectionFatory;
    }

    @ConfigurationProperty(name="createTableOnStart", parentElement="properties")
    public void setCreateTableOnStart(boolean createTableOnStart) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setCreateTableOnStart(createTableOnStart);
    }

    @ConfigurationProperty(name="dropTableOnExit", parentElement="properties")
    public void setDropTableOnExit(boolean dropTableOnExit) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setDropTableOnExit(dropTableOnExit);
    }

    @ConfigurationProperty(name="bucketTableNamePrefix", parentElement="properties")
    public void setBucketTableNamePrefix(String bucketTableName) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setTableNamePrefix(bucketTableName);
    }

    @ConfigurationProperty(name="idColumnName", parentElement="properties")
    public void setIdColumnName(String idColumnName) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setIdColumnName(idColumnName);
    }

    @ConfigurationProperty(name="idColumnType", parentElement="properties")
    public void setIdColumnType(String idColumnType) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setIdColumnType(idColumnType);
    }

    @ConfigurationProperty(name="dataColumnName", parentElement="properties")
    public void setDataColumnName(String dataColumnName) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setDataColumnName(dataColumnName);
    }

    @ConfigurationProperty(name="dataColumnType", parentElement="properties")
    public void setDataColumnType(String dataColumnType) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setDataColumnType(dataColumnType);
    }

    @ConfigurationProperty(name="timestampColumnName", parentElement="properties")
    public void setTimestampColumnName(String timestampColumnName) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setTimestampColumnName(timestampColumnName);
    }

    @ConfigurationProperty(name="timestampColumnType", parentElement="properties")
    public void setTimestampColumnType(String timestampColumnType) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setTimestampColumnType(timestampColumnType);
    }

    @ConfigurationProperty(name="connectionUrl", parentElement="properties")
    public void setConnectionUrl(String connectionUrl) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setConnectionUrl(connectionUrl);
    }

    @ConfigurationProperty(name="userName", parentElement="properties")
    public void setUserName(String userName) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setUserName(userName);
    }

    @ConfigurationProperty(name="password", parentElement="properties")
    public void setPassword(String password) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setPassword(password);
    }

    @ConfigurationProperty(name="driverClass", parentElement="properties")
    public void setDriverClass(String driverClass) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setDriverClass(driverClass);
    }

    @ConfigurationProperty(name="connectionFactoryClass", parentElement="properties")
    public void setConnectionFactoryClass(String connectionFactoryClass) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setConnectionFactoryClass(connectionFactoryClass);
    }

    public JdbcBinaryCacheStoreConfig clone() {
        JdbcBinaryCacheStoreConfig result = (JdbcBinaryCacheStoreConfig)super.clone();
        result.connectionFactoryConfig = this.connectionFactoryConfig.clone();
        result.tableManipulation = this.tableManipulation.clone();
        return result;
    }

    public ConnectionFactoryConfig getConnectionFactoryConfig() {
        return this.connectionFactoryConfig;
    }

    public TableManipulation getTableManipulation() {
        return this.tableManipulation;
    }

    public void setTableManipulation(TableManipulation tableManipulation) {
        this.testImmutability("tableManipulation");
        this.tableManipulation = tableManipulation;
    }

    @ConfigurationProperty(name="fetchSize", parentElement="properties")
    public void setFetchSize(int fetchSize) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setFetchSize(fetchSize);
    }

    @ConfigurationProperty(name="batchSize", parentElement="properties")
    public void setBatchSize(int batchSize) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setBatchSize(batchSize);
    }

    public int getFetchSize() {
        return this.tableManipulation.getFetchSize();
    }

    public int getBatchSize() {
        return this.tableManipulation.getBatchSize();
    }
}

