/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.connectionfactory;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.DataSources;
import java.beans.PropertyVetoException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.jdbc.JdbcUtil;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PooledConnectionFactory
extends ConnectionFactory {
    private static Log log = LogFactory.getLog(PooledConnectionFactory.class);
    private ComboPooledDataSource pooledDataSource;

    public void start(ConnectionFactoryConfig config) throws CacheLoaderException {
        this.logFileOverride();
        this.pooledDataSource = new ComboPooledDataSource();
        this.pooledDataSource.setProperties(new Properties());
        try {
            this.pooledDataSource.setDriverClass(config.getDriverClass());
        }
        catch (PropertyVetoException e) {
            String message = "Error while instatianting JDBC driver: '" + config.getDriverClass();
            log.error((Object)message, (Throwable)e);
            throw new CacheLoaderException(message, (Throwable)e);
        }
        this.pooledDataSource.setJdbcUrl(config.getConnectionUrl());
        this.pooledDataSource.setUser(config.getUserName());
        this.pooledDataSource.setPassword(config.getPassword());
        if (log.isTraceEnabled()) {
            log.trace((Object)("Started connection factory with config: " + config));
        }
    }

    private void logFileOverride() {
        URL propsUrl = Thread.currentThread().getContextClassLoader().getResource("c3p0.properties");
        URL xmlUrl = Thread.currentThread().getContextClassLoader().getResource("c3p0-config.xml");
        if (log.isInfoEnabled() && propsUrl != null) {
            log.info((Object)("Found 'c3p0.properties' in classpath: " + propsUrl));
        }
        if (log.isInfoEnabled() && xmlUrl != null) {
            log.info((Object)("Found 'c3p0-config.xml' in classpath: " + xmlUrl));
        }
    }

    public void stop() {
        try {
            DataSources.destroy((DataSource)this.pooledDataSource);
            if (log.isTraceEnabled()) {
                log.debug((Object)"Sucessfully stopped PooledConnectionFactory.");
            }
        }
        catch (SQLException sqle) {
            log.warn((Object)("Could not destroy C3P0 connection pool: " + this.pooledDataSource), (Throwable)sqle);
        }
    }

    public Connection getConnection() throws CacheLoaderException {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("DataSource before checkout (NumBusyConnectionsAllUsers) : " + this.pooledDataSource.getNumBusyConnectionsAllUsers()));
                log.trace((Object)("DataSource before checkout (NumConnectionsAllUsers) : " + this.pooledDataSource.getNumConnectionsAllUsers()));
            }
            Connection connection = this.pooledDataSource.getConnection();
            if (log.isTraceEnabled()) {
                log.trace((Object)("DataSource after checkout (NumBusyConnectionsAllUsers) : " + this.pooledDataSource.getNumBusyConnectionsAllUsers()));
                log.trace((Object)("DataSource after checkout (NumConnectionsAllUsers) : " + this.pooledDataSource.getNumConnectionsAllUsers()));
                log.trace((Object)("Connection checked out: " + connection));
            }
            return connection;
        }
        catch (SQLException e) {
            throw new CacheLoaderException("Failed obtaining connection from PooledDataSource", (Throwable)e);
        }
    }

    public void releaseConnection(Connection conn) {
        JdbcUtil.safeClose(conn);
    }

    public ComboPooledDataSource getPooledDataSource() {
        return this.pooledDataSource;
    }
}

