/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.connectionfactory;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SimpleConnectionFactory
extends ConnectionFactory {
    private static Log log = LogFactory.getLog(SimpleConnectionFactory.class);
    private String connectionUrl;
    private String userName;
    private String password;

    public void start(ConnectionFactoryConfig config) throws CacheLoaderException {
        this.loadDriver(config.getDriverClass());
        this.connectionUrl = config.getConnectionUrl();
        this.userName = config.getUserName();
        this.password = config.getPassword();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Starting connection " + this));
        }
    }

    public void stop() {
    }

    public Connection getConnection() throws CacheLoaderException {
        try {
            Connection connection = DriverManager.getConnection(this.connectionUrl, this.userName, this.password);
            if (connection == null) {
                throw new CacheLoaderException("Received null connection from the DriverManager!");
            }
            return connection;
        }
        catch (SQLException e) {
            throw new CacheLoaderException("Could not obtain a new connection", (Throwable)e);
        }
    }

    public void releaseConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException e) {
            log.warn((Object)"Failure while closing the connection to the database ", (Throwable)e);
        }
    }

    private void loadDriver(String driverClass) throws CacheLoaderException {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Attempting to load driver " + driverClass));
            }
            Util.getInstance((String)driverClass);
        }
        catch (Throwable th) {
            String message = "Failed loading driver with class: '" + driverClass + "'";
            log.error((Object)message, th);
            throw new CacheLoaderException(message, th);
        }
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return "SimpleConnectionFactory{connectionUrl='" + this.connectionUrl + '\'' + ", userName='" + this.userName + '\'' + "} " + super.toString();
    }
}

