/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.mixed;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.AbstractCacheStore;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStore;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStoreConfig;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStore;
import org.infinispan.marshall.Marshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcMixedCacheStore
extends AbstractCacheStore {
    private JdbcMixedCacheStoreConfig config;
    private JdbcBinaryCacheStore binaryCacheStore = new JdbcBinaryCacheStore();
    private JdbcStringBasedCacheStore stringBasedCacheStore = new JdbcStringBasedCacheStore();
    private ConnectionFactory sharedConnectionFactory;

    public void init(CacheLoaderConfig config, Cache cache, Marshaller m) throws CacheLoaderException {
        super.init(config, cache, m);
        this.config = (JdbcMixedCacheStoreConfig)config;
        this.binaryCacheStore.init((CacheLoaderConfig)this.config.getBinaryCacheStoreConfig(), cache, m);
        this.stringBasedCacheStore.init((CacheLoaderConfig)this.config.getStringCacheStoreConfig(), cache, m);
    }

    public void start() throws CacheLoaderException {
        super.start();
        ConnectionFactoryConfig factoryConfig = this.config.getConnectionFactoryConfig();
        this.sharedConnectionFactory = ConnectionFactory.getConnectionFactory(factoryConfig.getConnectionFactoryClass());
        this.sharedConnectionFactory.start(factoryConfig);
        this.binaryCacheStore.doConnectionFactoryInitialization(this.sharedConnectionFactory);
        this.binaryCacheStore.start();
        this.stringBasedCacheStore.doConnectionFactoryInitialization(this.sharedConnectionFactory);
        this.stringBasedCacheStore.start();
    }

    public void stop() throws CacheLoaderException {
        super.stop();
        this.binaryCacheStore.stop();
        this.stringBasedCacheStore.stop();
        this.sharedConnectionFactory.stop();
    }

    protected void purgeInternal() throws CacheLoaderException {
        this.binaryCacheStore.purgeInternal();
        this.stringBasedCacheStore.purgeInternal();
    }

    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        return this.getCacheStore(key).load(key);
    }

    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        Set fromBuckets = this.binaryCacheStore.loadAll();
        Set fromStrings = this.stringBasedCacheStore.loadAll();
        fromBuckets.addAll(fromStrings);
        return fromBuckets;
    }

    public void store(InternalCacheEntry ed) throws CacheLoaderException {
        this.getCacheStore(ed.getKey()).store(ed);
    }

    public void fromStream(ObjectInput inputStream) throws CacheLoaderException {
        this.binaryCacheStore.fromStream(inputStream);
        this.stringBasedCacheStore.fromStream(inputStream);
    }

    public void toStream(ObjectOutput outputStream) throws CacheLoaderException {
        this.binaryCacheStore.toStream(outputStream);
        this.stringBasedCacheStore.toStream(outputStream);
    }

    public boolean remove(Object key) throws CacheLoaderException {
        return this.getCacheStore(key).remove(key);
    }

    public void clear() throws CacheLoaderException {
        this.binaryCacheStore.clear();
        this.stringBasedCacheStore.clear();
    }

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return JdbcMixedCacheStoreConfig.class;
    }

    private CacheStore getCacheStore(Object key) {
        return this.stringBasedCacheStore.supportsKey(key.getClass()) ? this.stringBasedCacheStore : this.binaryCacheStore;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.sharedConnectionFactory;
    }

    public JdbcBinaryCacheStore getBinaryCacheStore() {
        return this.binaryCacheStore;
    }

    public JdbcStringBasedCacheStore getStringBasedCacheStore() {
        return this.stringBasedCacheStore;
    }
}

