/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.mixed;

import org.infinispan.config.ConfigurationElement;
import org.infinispan.config.ConfigurationElements;
import org.infinispan.config.ConfigurationProperty;
import org.infinispan.loaders.AbstractCacheStoreConfig;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStoreConfig;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStore;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStoreConfig;

@ConfigurationElements(elements={@ConfigurationElement(name="loader", parent="loaders", description="org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStore", cardinalityInParent=ConfigurationElement.Cardinality.UNBOUNDED), @ConfigurationElement(name="properties", parent="loader")})
public class JdbcMixedCacheStoreConfig
extends AbstractCacheStoreConfig {
    private ConnectionFactoryConfig connectionFactoryConfig = new ConnectionFactoryConfig();
    private TableManipulation binaryTableManipulation = new TableManipulation();
    private TableManipulation stringsTableManipulation = new TableManipulation();
    private String key2StringMapper;
    private int binaryConcurrencyLevel = 1024;
    private int stringsConcurrencyLevel = 1024;
    private int lockAcquistionTimeout = 60000;

    public JdbcMixedCacheStoreConfig(ConnectionFactoryConfig connectionFactoryConfig, TableManipulation binaryTableManipulation, TableManipulation stringsTableManipulation) {
        this.connectionFactoryConfig = connectionFactoryConfig;
        this.binaryTableManipulation = binaryTableManipulation;
        this.stringsTableManipulation = stringsTableManipulation;
    }

    public JdbcMixedCacheStoreConfig() {
        this.cacheLoaderClassName = JdbcMixedCacheStore.class.getName();
    }

    public void setConnectionFactoryConfig(ConnectionFactoryConfig connectionFactoryConfig) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig = connectionFactoryConfig;
    }

    public void setBinaryTableManipulation(TableManipulation binaryTableManipulation) {
        this.testImmutability("binaryTableManipulation");
        this.binaryTableManipulation = binaryTableManipulation;
    }

    public void setStringsTableManipulation(TableManipulation stringsTableManipulation) {
        this.testImmutability("stringsTableManipulation");
        this.stringsTableManipulation = stringsTableManipulation;
    }

    JdbcBinaryCacheStoreConfig getBinaryCacheStoreConfig() {
        JdbcBinaryCacheStoreConfig cacheStoreConfig = new JdbcBinaryCacheStoreConfig(false);
        cacheStoreConfig.setTableManipulation(this.binaryTableManipulation);
        cacheStoreConfig.setPurgeSynchronously(true);
        cacheStoreConfig.setLockConcurrencyLevel(this.binaryConcurrencyLevel);
        cacheStoreConfig.setLockAcquistionTimeout(this.lockAcquistionTimeout);
        return cacheStoreConfig;
    }

    JdbcStringBasedCacheStoreConfig getStringCacheStoreConfig() {
        JdbcStringBasedCacheStoreConfig config = new JdbcStringBasedCacheStoreConfig(false);
        config.setTableManipulation(this.stringsTableManipulation);
        config.setPurgeSynchronously(true);
        config.setLockConcurrencyLevel(this.stringsConcurrencyLevel);
        config.setLockAcquistionTimeout(this.lockAcquistionTimeout);
        if (this.key2StringMapper != null) {
            config.setKey2StringMapperClass(this.key2StringMapper);
        }
        return config;
    }

    @ConfigurationProperty(name="idColumnNameForStrings", parentElement="properties")
    public void setIdColumnNameForStrings(String idColumnNameForStrings) {
        this.testImmutability("stringsTableManipulation");
        this.stringsTableManipulation.setIdColumnName(idColumnNameForStrings);
    }

    @ConfigurationProperty(name="idColumnTypeForStrings", parentElement="properties")
    public void setIdColumnTypeForStrings(String idColumnTypeForStrings) {
        this.testImmutability("stringsTableManipulation");
        this.stringsTableManipulation.setIdColumnType(idColumnTypeForStrings);
    }

    @ConfigurationProperty(name="tableNamePrefixForStrings", parentElement="properties")
    public void setTableNamePrefixForStrings(String tableNameForStrings) {
        this.testImmutability("stringsTableManipulation");
        if (tableNameForStrings == null) {
            throw new IllegalArgumentException("Null table name not allowed.");
        }
        if (tableNameForStrings.equals(this.binaryTableManipulation.getTableNamePrefix())) {
            throw new IllegalArgumentException("Same table name is used for both cache loaders, this is not allowed!");
        }
        this.stringsTableManipulation.setTableNamePrefix(tableNameForStrings);
    }

    @ConfigurationProperty(name="dataColumnNameForStrings", parentElement="properties")
    public void setDataColumnNameForStrings(String dataColumnNameForStrings) {
        this.testImmutability("stringsTableManipulation");
        this.stringsTableManipulation.setDataColumnName(dataColumnNameForStrings);
    }

    @ConfigurationProperty(name="dataColumnTypeForStrings", parentElement="properties")
    public void setDataColumnTypeForStrings(String dataColumnTypeForStrings) {
        this.testImmutability("stringsTableManipulation");
        this.stringsTableManipulation.setDataColumnType(dataColumnTypeForStrings);
    }

    @ConfigurationProperty(name="timestampColumnNameForStrings", parentElement="properties")
    public void setTimestampColumnNameForStrings(String timestampColumnNameForStrings) {
        this.testImmutability("stringsTableManipulation");
        this.stringsTableManipulation.setTimestampColumnName(timestampColumnNameForStrings);
    }

    @ConfigurationProperty(name="timestampColumnTypeForStrings", parentElement="properties")
    public void setTimestampColumnTypeForStrings(String timestampColumnTypeForStrings) {
        this.testImmutability("stringsTableManipulation");
        this.stringsTableManipulation.setTimestampColumnType(timestampColumnTypeForStrings);
    }

    @ConfigurationProperty(name="createTableOnStartForStrings", parentElement="properties")
    public void setCreateTableOnStartForStrings(boolean createTableOnStartForStrings) {
        this.testImmutability("stringsTableManipulation");
        this.stringsTableManipulation.setCreateTableOnStart(createTableOnStartForStrings);
    }

    @ConfigurationProperty(name="dropTableOnExitForStrings", parentElement="properties")
    public void setDropTableOnExitForStrings(boolean dropTableOnExitForStrings) {
        this.testImmutability("stringsTableManipulation");
        this.stringsTableManipulation.setDropTableOnExit(dropTableOnExitForStrings);
    }

    @ConfigurationProperty(name="idColumnNameForBinary", parentElement="properties")
    public void setIdColumnNameForBinary(String idColumnNameForBinary) {
        this.binaryTableManipulation.setIdColumnName(idColumnNameForBinary);
    }

    @ConfigurationProperty(name="idColumnTypeForBinary", parentElement="properties")
    public void setIdColumnTypeForBinary(String idColumnTypeForBinary) {
        this.testImmutability("stringsTableManipulation");
        this.binaryTableManipulation.setIdColumnType(idColumnTypeForBinary);
    }

    @ConfigurationProperty(name="tableNamePrefixForBinary", parentElement="properties")
    public void setTableNamePrefixForBinary(String tableNameForBinary) {
        this.testImmutability("binaryTableManipulation");
        if (tableNameForBinary == null) {
            throw new IllegalArgumentException("Null table name not allowed.");
        }
        if (tableNameForBinary.equals(this.stringsTableManipulation.getTableNamePrefix())) {
            throw new IllegalArgumentException("Same table name is used for both cache loaders, this is not allowed!");
        }
        this.binaryTableManipulation.setTableNamePrefix(tableNameForBinary);
    }

    @ConfigurationProperty(name="dataColumnNameForBinary", parentElement="properties")
    public void setDataColumnNameForBinary(String dataColumnNameForBinary) {
        this.testImmutability("binaryTableManipulation");
        this.binaryTableManipulation.setDataColumnName(dataColumnNameForBinary);
    }

    @ConfigurationProperty(name="dataColumnTypeForBinary", parentElement="properties")
    public void setDataColumnTypeForBinary(String dataColumnTypeForBinary) {
        this.testImmutability("binaryTableManipulation");
        this.binaryTableManipulation.setDataColumnType(dataColumnTypeForBinary);
    }

    @ConfigurationProperty(name="timestampColumnNameForBinary", parentElement="properties")
    public void setTimestampColumnNameForBinary(String timestampColumnNameForBinary) {
        this.testImmutability("binaryTableManipulation");
        this.binaryTableManipulation.setTimestampColumnName(timestampColumnNameForBinary);
    }

    @ConfigurationProperty(name="timestampColumnTypeForBinary", parentElement="properties")
    public void setTimestampColumnTypeForBinary(String timestampColumnTypeForBinary) {
        this.binaryTableManipulation.setTimestampColumnType(timestampColumnTypeForBinary);
    }

    @ConfigurationProperty(name="createTableOnStartForBinary", parentElement="properties")
    public void setCreateTableOnStartForBinary(boolean createTableOnStartForBinary) {
        this.testImmutability("binaryTableManipulation");
        this.binaryTableManipulation.setCreateTableOnStart(createTableOnStartForBinary);
    }

    @ConfigurationProperty(name="dropTableOnExitForBinary", parentElement="properties")
    public void setDropTableOnExitForBinary(boolean dropTableOnExitForBinary) {
        this.testImmutability("binaryTableManipulation");
        this.binaryTableManipulation.setDropTableOnExit(dropTableOnExitForBinary);
    }

    @ConfigurationProperty(name="driverClass", parentElement="properties")
    public void setDriverClass(String driverClass) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setDriverClass(driverClass);
    }

    @ConfigurationProperty(name="connectionUrl", parentElement="properties")
    public void setConnectionUrl(String connectionUrl) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setConnectionUrl(connectionUrl);
    }

    @ConfigurationProperty(name="userName", parentElement="properties")
    public void setUserName(String userName) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setUserName(userName);
    }

    @ConfigurationProperty(name="password", parentElement="properties")
    public void setPassword(String password) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setPassword(password);
    }

    @ConfigurationProperty(name="connectionFactoryClass", parentElement="properties")
    public void setConnectionFactoryClass(String connectionFactoryClass) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setConnectionFactoryClass(connectionFactoryClass);
    }

    public ConnectionFactoryConfig getConnectionFactoryConfig() {
        return this.connectionFactoryConfig;
    }

    @ConfigurationProperty(name="key2StringMapperClass", parentElement="properties")
    public void setKey2StringMapperClass(String name) {
        this.testImmutability("key2StringMapper");
        this.key2StringMapper = name;
    }

    @ConfigurationProperty(name="lockConcurrencyLevelForStrings", parentElement="properties")
    public void setLockConcurrencyLevelForStrings(int concurrencyLevel) {
        this.testImmutability("stringsConcurrencyLevel");
        this.stringsConcurrencyLevel = concurrencyLevel;
    }

    @ConfigurationProperty(name="lockConcurrencyLevelForBinary", parentElement="properties")
    public void setLockConcurrencyLevelForBinary(int concurrencyLevel) {
        this.testImmutability("binaryConcurrencyLevel");
        this.binaryConcurrencyLevel = concurrencyLevel;
    }

    @ConfigurationProperty(name="lockAcquistionTimeout", parentElement="properties")
    public void setLockAcquistionTimeout(int lockAcquistionTimeout) {
        this.testImmutability("lockAcquistionTimeout");
        this.lockAcquistionTimeout = lockAcquistionTimeout;
    }

    @ConfigurationProperty(name="fetchSize", parentElement="properties")
    public void setFetchSize(int fetchSize) {
        this.testImmutability("tableManipulation");
        this.binaryTableManipulation.setFetchSize(fetchSize);
        this.stringsTableManipulation.setFetchSize(fetchSize);
    }

    @ConfigurationProperty(name="batchSize", parentElement="properties")
    public void setBatchSize(int batchSize) {
        this.testImmutability("tableManipulation");
        this.binaryTableManipulation.setBatchSize(batchSize);
        this.stringsTableManipulation.setBatchSize(batchSize);
    }

    public JdbcMixedCacheStoreConfig clone() {
        JdbcMixedCacheStoreConfig dolly = (JdbcMixedCacheStoreConfig)super.clone();
        dolly.connectionFactoryConfig = this.connectionFactoryConfig.clone();
        dolly.binaryTableManipulation = this.binaryTableManipulation.clone();
        dolly.stringsTableManipulation = this.stringsTableManipulation.clone();
        return dolly;
    }
}

