/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.stringbased;

import org.infinispan.config.ConfigurationElement;
import org.infinispan.config.ConfigurationElements;
import org.infinispan.config.ConfigurationProperty;
import org.infinispan.loaders.LockSupportCacheStoreConfig;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.stringbased.DefaultKey2StringMapper;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStore;
import org.infinispan.loaders.jdbc.stringbased.Key2StringMapper;
import org.infinispan.util.Util;

@ConfigurationElements(elements={@ConfigurationElement(name="loader", parent="loaders", description="org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStore", cardinalityInParent=ConfigurationElement.Cardinality.UNBOUNDED), @ConfigurationElement(name="properties", parent="loader")})
public class JdbcStringBasedCacheStoreConfig
extends LockSupportCacheStoreConfig {
    private Key2StringMapper key2StringMapper;
    private ConnectionFactoryConfig connectionFactoryConfig = new ConnectionFactoryConfig();
    private TableManipulation tableManipulation = new TableManipulation();
    private boolean manageConnectionFactory = true;

    public JdbcStringBasedCacheStoreConfig(ConnectionFactoryConfig connectionFactoryConfig, TableManipulation tableManipulation) {
        this();
        this.connectionFactoryConfig = connectionFactoryConfig;
        this.tableManipulation = tableManipulation;
    }

    public JdbcStringBasedCacheStoreConfig() {
        this.cacheLoaderClassName = JdbcStringBasedCacheStore.class.getName();
    }

    public JdbcStringBasedCacheStoreConfig(boolean manageConnectionFactory) {
        this();
        this.manageConnectionFactory = manageConnectionFactory;
    }

    public Key2StringMapper getKey2StringMapper() {
        if (this.key2StringMapper == null) {
            try {
                this.key2StringMapper = (Key2StringMapper)DefaultKey2StringMapper.class.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("This should never happen", e);
            }
        }
        return this.key2StringMapper;
    }

    @ConfigurationProperty(name="key2StringMapper", parentElement="properties")
    public void setKey2StringMapperClass(String className) {
        this.testImmutability("key2StringMapper");
        try {
            this.key2StringMapper = (Key2StringMapper)Util.getInstance((String)className);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not load Key2StringMapper :'" + className + "'", e);
        }
    }

    @ConfigurationProperty(name="stringsTableNamePrefix", parentElement="properties")
    public void setStringsTableNamePrefix(String stringsTableNamePrefix) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setTableNamePrefix(stringsTableNamePrefix);
    }

    public void setCacheName(String cacheName) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setCacheName(cacheName);
    }

    @ConfigurationProperty(name="idColumnName", parentElement="properties")
    public void setIdColumnName(String idColumnName) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setIdColumnName(idColumnName);
    }

    @ConfigurationProperty(name="dataColumnName", parentElement="properties")
    public void setDataColumnName(String dataColumnName) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setDataColumnName(dataColumnName);
    }

    @ConfigurationProperty(name="timestampColumnName", parentElement="properties")
    public void setTimestampColumnName(String timestampColumnName) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setTimestampColumnName(timestampColumnName);
    }

    @ConfigurationProperty(name="timestampColumnType", parentElement="properties")
    public void setTimestampColumnType(String timestampColumnType) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setTimestampColumnType(timestampColumnType);
    }

    @ConfigurationProperty(name="connectionFactoryClass", parentElement="properties")
    public void setConnectionFactoryClass(String connectionFactoryClass) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setConnectionFactoryClass(connectionFactoryClass);
    }

    public ConnectionFactoryConfig getConnectionFactoryConfig() {
        return this.connectionFactoryConfig;
    }

    public TableManipulation getTableManipulation() {
        return this.tableManipulation;
    }

    @ConfigurationProperty(name="connectionUrl", parentElement="properties")
    public void setConnectionUrl(String connectionUrl) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setConnectionUrl(connectionUrl);
    }

    @ConfigurationProperty(name="userName", parentElement="properties")
    public void setUserName(String userName) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setUserName(userName);
    }

    @ConfigurationProperty(name="password", parentElement="properties")
    public void setPassword(String password) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setPassword(password);
    }

    @ConfigurationProperty(name="driverClass", parentElement="properties")
    public void setDriverClass(String driverClassName) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setDriverClass(driverClassName);
    }

    @ConfigurationProperty(name="idColumnType", parentElement="properties")
    public void setIdColumnType(String idColumnType) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setIdColumnType(idColumnType);
    }

    @ConfigurationProperty(name="dataColumnType", parentElement="properties")
    public void setDataColumnType(String dataColumnType) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setDataColumnType(dataColumnType);
    }

    @ConfigurationProperty(name="dropTableOnExit", parentElement="properties")
    public void setDropTableOnExit(boolean dropTableOnExit) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setDropTableOnExit(dropTableOnExit);
    }

    @ConfigurationProperty(name="createTableOnStart", parentElement="properties")
    public void setCreateTableOnStart(boolean createTableOnStart) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setCreateTableOnStart(createTableOnStart);
    }

    boolean isManageConnectionFactory() {
        return this.manageConnectionFactory;
    }

    public void setTableManipulation(TableManipulation tableManipulation) {
        this.testImmutability("tableManipulation");
        this.tableManipulation = tableManipulation;
    }

    @ConfigurationProperty(name="fetchSize", parentElement="properties")
    public void setFetchSize(int fetchSize) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setFetchSize(fetchSize);
    }

    @ConfigurationProperty(name="batchSize", parentElement="properties")
    public void setBatchSize(int batchSize) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setBatchSize(batchSize);
    }

    public int getFetchSize() {
        return this.tableManipulation.getFetchSize();
    }

    public int getBatchSize() {
        return this.tableManipulation.getBatchSize();
    }

    public JdbcStringBasedCacheStoreConfig clone() {
        JdbcStringBasedCacheStoreConfig result = (JdbcStringBasedCacheStoreConfig)super.clone();
        result.connectionFactoryConfig = this.connectionFactoryConfig.clone();
        result.tableManipulation = this.tableManipulation.clone();
        return result;
    }
}

