/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.stringbased;

import org.easymock.classextension.EasyMock;
import org.infinispan.Cache;
import org.infinispan.CacheDelegate;
import org.infinispan.loaders.BaseCacheStoreTest;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStore;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStoreConfig;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.stringbased.JdbcStringBasedCacheStoreTest")
public class JdbcStringBasedCacheStoreTest
extends BaseCacheStoreTest {
    protected CacheStore createCacheStore() throws Exception {
        ConnectionFactoryConfig connectionFactoryConfig = UnitTestDatabaseManager.getUniqueConnectionFactoryConfig();
        TableManipulation tm = UnitTestDatabaseManager.buildDefaultTableManipulation();
        JdbcStringBasedCacheStoreConfig config = new JdbcStringBasedCacheStoreConfig(connectionFactoryConfig, tm);
        JdbcStringBasedCacheStore stringBasedCacheStore = new JdbcStringBasedCacheStore();
        stringBasedCacheStore.init((CacheLoaderConfig)config, (Cache)new CacheDelegate("aName"), this.getMarshaller());
        stringBasedCacheStore.start();
        return stringBasedCacheStore;
    }

    public void testNotCreateConnectionFactory() throws Exception {
        JdbcStringBasedCacheStore stringBasedCacheStore = new JdbcStringBasedCacheStore();
        JdbcStringBasedCacheStoreConfig config = new JdbcStringBasedCacheStoreConfig(false);
        config.setCreateTableOnStart(false);
        stringBasedCacheStore.init((CacheLoaderConfig)config, (Cache)new CacheDelegate("otherName"), this.getMarshaller());
        stringBasedCacheStore.start();
        assert (stringBasedCacheStore.getConnectionFactory() == null);
        ConnectionFactory connectionFactory = (ConnectionFactory)EasyMock.createMock(ConnectionFactory.class);
        TableManipulation tableManipulation = (TableManipulation)EasyMock.createMock(TableManipulation.class);
        config.setTableManipulation(tableManipulation);
        tableManipulation.start(connectionFactory);
        tableManipulation.setCacheName("otherName");
        EasyMock.replay((Object[])new Object[]{tableManipulation});
        stringBasedCacheStore.doConnectionFactoryInitialization(connectionFactory);
        EasyMock.verify((Object[])new Object[]{tableManipulation});
        EasyMock.reset((Object[])new Object[]{tableManipulation, connectionFactory});
        tableManipulation.stop();
        EasyMock.replay((Object[])new Object[]{tableManipulation, connectionFactory});
        stringBasedCacheStore.stop();
        EasyMock.verify((Object[])new Object[]{tableManipulation, connectionFactory});
    }
}

