/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.fwk;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.loaders.jdbc.JdbcUtil;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.connectionfactory.PooledConnectionFactory;

public class UnitTestDatabaseManager {
    private static final ConnectionFactoryConfig realConfig = new ConnectionFactoryConfig();
    private static AtomicInteger userIndex = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionFactoryConfig getUniqueConnectionFactoryConfig() {
        ConnectionFactoryConfig connectionFactoryConfig = realConfig;
        synchronized (connectionFactoryConfig) {
            return UnitTestDatabaseManager.returnBasedOnDifferentInstance();
        }
    }

    public static void shutdownInMemoryDatabase(ConnectionFactoryConfig config) {
    }

    public static String getDatabaseName(Properties prop) {
        StringTokenizer tokenizer = new StringTokenizer(prop.getProperty("cache.jdbc.url"), ":");
        tokenizer.nextToken();
        tokenizer.nextToken();
        tokenizer.nextToken();
        return tokenizer.nextToken();
    }

    private static String getShutdownUrl(ConnectionFactoryConfig props) {
        String url = props.getConnectionUrl();
        assert (url != null);
        StringTokenizer tokenizer = new StringTokenizer(url, ";");
        String result = tokenizer.nextToken() + ";" + "shutdown=true";
        return result;
    }

    private static ConnectionFactoryConfig returnBasedOnDifferentInstance() {
        ConnectionFactoryConfig result = realConfig.clone();
        String jdbcUrl = result.getConnectionUrl();
        Pattern pattern = Pattern.compile("infinispan");
        Matcher matcher = pattern.matcher(jdbcUrl);
        boolean found = matcher.find();
        assert (found) : String.format("%1s not found in %2s", pattern, jdbcUrl);
        String newJdbcUrl = matcher.replaceFirst(UnitTestDatabaseManager.extractTestName() + userIndex.incrementAndGet());
        result.setConnectionUrl(newJdbcUrl);
        return result;
    }

    private static String extractTestName() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length == 0) {
            return null;
        }
        for (int i = stack.length - 1; i > 0; --i) {
            StackTraceElement e = stack[i];
            String className = e.getClassName();
            if (className.indexOf("org.infinispan") == -1) continue;
            return className.replace('.', '_') + "_" + e.getMethodName();
        }
        return null;
    }

    public static TableManipulation buildDefaultTableManipulation() {
        return new TableManipulation("ID_COLUMN", "VARCHAR(255)", "ISPN_JDBC", "DATA_COLUMN", "BLOB", "TIMESTAMP_COLUMN", "BIGINT");
    }

    public static int rowCount(ConnectionFactory connectionFactory, String tableName) {
        int n;
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            conn = connectionFactory.getConnection();
            String sql = "SELECT count(*) FROM " + tableName;
            statement = conn.prepareStatement(sql);
            resultSet = statement.executeQuery();
            resultSet.next();
            n = resultSet.getInt(1);
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(resultSet);
                JdbcUtil.safeClose(statement);
                connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose((ResultSet)resultSet);
        JdbcUtil.safeClose((Statement)statement);
        connectionFactory.releaseConnection(conn);
        return n;
    }

    static {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        realConfig.setDriverClass("org.h2.Driver");
        realConfig.setConnectionUrl("jdbc:h2:mem:infinispan;DB_CLOSE_DELAY=-1");
        realConfig.setConnectionFactoryClass(PooledConnectionFactory.class.getName());
        realConfig.setUserName("sa");
    }
}

