/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.jdbc.JdbcUtil;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.marshall.Marshaller;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class DataManipulationHelper {
    private static Log log = LogFactory.getLog(DataManipulationHelper.class);
    private ConnectionFactory connectionFactory;
    private TableManipulation tableManipulation;
    protected Marshaller marshaller;

    public DataManipulationHelper(ConnectionFactory connectionFactory, TableManipulation tableManipulation, Marshaller marshaller) {
        this.connectionFactory = connectionFactory;
        this.tableManipulation = tableManipulation;
        this.marshaller = marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws CacheLoaderException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            String sql = this.tableManipulation.getDeleteAllRowsSql();
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            int result = ps.executeUpdate();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Successfully removed " + result + " rows."));
            }
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
        }
        catch (SQLException ex) {
            DataManipulationHelper.logAndThrow(ex, "Failed clearing JdbcBinaryCacheStore");
        }
        finally {
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
        }
    }

    /*
     * Exception decompiling
     */
    public final void fromStreamSupport(ObjectInput objectInput) throws CacheLoaderException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void toStreamSupport(ObjectOutput objectOutput, byte streamDelimiter, boolean filterExpired) throws CacheLoaderException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql;
            String string = sql = filterExpired ? this.tableManipulation.getLoadNonExpiredAllRowsSql() : this.tableManipulation.getLoadAllRowsSql();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Running sql '" + sql));
            }
            connection = this.connectionFactory.getConnection();
            ps = connection.prepareStatement(sql);
            if (filterExpired) {
                ps.setLong(1, System.currentTimeMillis());
            }
            rs = ps.executeQuery();
            rs.setFetchSize(this.tableManipulation.getFetchSize());
            while (rs.next()) {
                InputStream is = rs.getBinaryStream(1);
                this.toStreamProcess(rs, is, objectOutput);
            }
            this.marshaller.objectToObjectStream((Object)streamDelimiter, objectOutput);
        }
        catch (SQLException e) {
            DataManipulationHelper.logAndThrow(e, "SQL Error while storing string keys to database");
            JdbcUtil.safeClose(rs);
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(connection);
        }
        catch (IOException e2) {
            DataManipulationHelper.logAndThrow(e2, "I/O Error while storing string keys to database");
            {
                catch (Throwable throwable) {
                    JdbcUtil.safeClose(rs);
                    JdbcUtil.safeClose(ps);
                    this.connectionFactory.releaseConnection(connection);
                    throw throwable;
                }
            }
            JdbcUtil.safeClose(rs);
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(connection);
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(connection);
    }

    public final Set<InternalCacheEntry> loadAllSupport(boolean filterExpired) throws CacheLoaderException {
        HashSet<InternalCacheEntry> hashSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql;
            String string = sql = filterExpired ? this.tableManipulation.getLoadNonExpiredAllRowsSql() : this.tableManipulation.getLoadAllRowsSql();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Running sql '" + sql));
            }
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            if (filterExpired) {
                ps.setLong(1, System.currentTimeMillis());
            }
            rs = ps.executeQuery();
            rs.setFetchSize(this.tableManipulation.getFetchSize());
            HashSet<InternalCacheEntry> result = new HashSet<InternalCacheEntry>();
            while (rs.next()) {
                this.loadAllProcess(rs, result);
            }
            hashSet = result;
        }
        catch (SQLException e) {
            try {
                String message = "SQL error while fetching all StoredEntries";
                log.error((Object)message, (Throwable)e);
                throw new CacheLoaderException(message, (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
        return hashSet;
    }

    public abstract void loadAllProcess(ResultSet var1, Set<InternalCacheEntry> var2) throws SQLException, CacheLoaderException;

    public abstract void toStreamProcess(ResultSet var1, InputStream var2, ObjectOutput var3) throws CacheLoaderException, SQLException, IOException;

    public abstract boolean fromStreamProcess(Object var1, PreparedStatement var2, ObjectInput var3) throws SQLException, CacheLoaderException, IOException, ClassNotFoundException;

    public static void logAndThrow(Exception e, String message) throws CacheLoaderException {
        log.error((Object)message, (Throwable)e);
        throw new CacheLoaderException(message, (Throwable)e);
    }
}

