/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import org.infinispan.Cache;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.jdbc.TableManipulationTest;
import org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStore;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStore;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStore;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStoreConfig;
import org.infinispan.manager.CacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.TableNameUniquenessTest")
public class TableNameUniquenessTest
extends AbstractInfinispanTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForJdbcStringBasedCacheStore() throws Exception {
        CacheManager cm = null;
        try {
            cm = TestCacheManagerFactory.fromXml((String)"configs/string-based.xml");
            Cache first = cm.getCache("first");
            Cache second = cm.getCache("second");
            CacheLoaderConfig firstCacheLoaderConfig = first.getConfiguration().getCacheLoaderManagerConfig().getFirstCacheLoaderConfig();
            assert (firstCacheLoaderConfig != null);
            CacheLoaderConfig secondCacheLoaderConfig = second.getConfiguration().getCacheLoaderManagerConfig().getFirstCacheLoaderConfig();
            assert (secondCacheLoaderConfig != null);
            assert (firstCacheLoaderConfig instanceof JdbcStringBasedCacheStoreConfig);
            assert (secondCacheLoaderConfig instanceof JdbcStringBasedCacheStoreConfig);
            JdbcStringBasedCacheStore firstCs = (JdbcStringBasedCacheStore)((CacheLoaderManager)TestingUtil.extractComponent((Cache)first, CacheLoaderManager.class)).getCacheLoader();
            JdbcStringBasedCacheStore secondCs = (JdbcStringBasedCacheStore)((CacheLoaderManager)TestingUtil.extractComponent((Cache)second, CacheLoaderManager.class)).getCacheLoader();
            this.asserTableExistance(firstCs.getConnectionFactory().getConnection(), "ISPN_STRING_TABLE_second", "ISPN_STRING_TABLE_first", "ISPN_STRING_TABLE");
            this.assertNoOverlapingState((Cache<String, String>)first, (Cache<String, String>)second, (CacheStore)firstCs, (CacheStore)secondCs);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((CacheManager[])new CacheManager[]{cm});
            throw throwable;
        }
        TestingUtil.killCacheManagers((CacheManager[])new CacheManager[]{cm});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForJdbcBinaryCacheStore() throws Exception {
        CacheManager cm = null;
        try {
            cm = TestCacheManagerFactory.fromXml((String)"configs/binary.xml");
            Cache first = cm.getCache("first");
            Cache second = cm.getCache("second");
            JdbcBinaryCacheStore firstCs = (JdbcBinaryCacheStore)((CacheLoaderManager)TestingUtil.extractComponent((Cache)first, CacheLoaderManager.class)).getCacheLoader();
            JdbcBinaryCacheStore secondCs = (JdbcBinaryCacheStore)((CacheLoaderManager)TestingUtil.extractComponent((Cache)second, CacheLoaderManager.class)).getCacheLoader();
            this.asserTableExistance(firstCs.getConnectionFactory().getConnection(), "ISPN_BUCKET_TABLE_second", "ISPN_BUCKET_TABLE_first", "IISPN_BUCKET_TABLE");
            this.assertNoOverlapingState((Cache<String, String>)first, (Cache<String, String>)second, (CacheStore)firstCs, (CacheStore)secondCs);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((CacheManager[])new CacheManager[]{cm});
            throw throwable;
        }
        TestingUtil.killCacheManagers((CacheManager[])new CacheManager[]{cm});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForMixedCacheStore() throws Exception {
        CacheManager cm = null;
        try {
            cm = TestCacheManagerFactory.fromXml((String)"configs/mixed.xml");
            Cache first = cm.getCache("first");
            Cache second = cm.getCache("second");
            JdbcMixedCacheStore firstCs = (JdbcMixedCacheStore)((CacheLoaderManager)TestingUtil.extractComponent((Cache)first, CacheLoaderManager.class)).getCacheLoader();
            JdbcMixedCacheStore secondCs = (JdbcMixedCacheStore)((CacheLoaderManager)TestingUtil.extractComponent((Cache)second, CacheLoaderManager.class)).getCacheLoader();
            this.asserTableExistance(firstCs.getConnectionFactory().getConnection(), "ISPN_MIXED_STR_TABLE_second", "ISPN_MIXED_STR_TABLE_first", "ISPN_MIXED_STR_TABLE");
            this.asserTableExistance(firstCs.getConnectionFactory().getConnection(), "ISPN_MIXED_BINARY_TABLE_second", "ISPN_MIXED_BINARY_TABLE_first", "ISPN_MIXED_BINARY_TABLE");
            this.assertNoOverlapingState((Cache<String, String>)first, (Cache<String, String>)second, (CacheStore)firstCs, (CacheStore)secondCs);
            Person person1 = new Person(29, "Mircea");
            Person person2 = new Person(29, "Manik");
            first.put((Object)"k", (Object)person1);
            assert (firstCs.containsKey((Object)"k"));
            assert (!secondCs.containsKey((Object)"k"));
            assert (first.get((Object)"k").equals(person1));
            assert (second.get((Object)"k") == null);
            second.put((Object)"k2", (Object)person2);
            assert (second.get((Object)"k2").equals(person2));
            assert (first.get((Object)"k2") == null);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((CacheManager[])new CacheManager[]{cm});
            throw throwable;
        }
        TestingUtil.killCacheManagers((CacheManager[])new CacheManager[]{cm});
    }

    private void asserTableExistance(Connection connection, String secondTable, String firstTable, String tablePrefix) throws Exception {
        assert (!TableManipulationTest.existsTable(connection, tablePrefix)) : "this table should not exist!";
        assert (TableManipulationTest.existsTable(connection, firstTable));
        assert (TableManipulationTest.existsTable(connection, secondTable));
        connection.close();
    }

    private void assertNoOverlapingState(Cache<String, String> first, Cache<String, String> second, CacheStore firstCs, CacheStore secondCs) throws CacheLoaderException {
        first.put((Object)"k", (Object)"v");
        assert (firstCs.containsKey((Object)"k"));
        assert (!secondCs.containsKey((Object)"k"));
        assert (((String)first.get((Object)"k")).equals("v"));
        assert (second.get((Object)"k") == null);
        second.put((Object)"k2", (Object)"v2");
        assert (((String)second.get((Object)"k2")).equals("v2"));
        assert (first.get((Object)"k2") == null);
    }

    static class Person
    implements Serializable {
        int age;
        String name;
        private static final long serialVersionUID = 4227565864228124235L;

        Person(int age, String name) {
            this.age = age;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Person)) {
                return false;
            }
            Person person = (Person)o;
            if (this.age != person.age) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(person.name) : person.name != null);
        }

        public int hashCode() {
            int result = this.age;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}

