/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.binary;

import org.easymock.classextension.EasyMock;
import org.infinispan.Cache;
import org.infinispan.CacheDelegate;
import org.infinispan.loaders.BaseCacheStoreTest;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStore;
import org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStoreConfig;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.binary.JdbcBinaryCacheStoreTest")
public class JdbcBinaryCacheStoreTest
extends BaseCacheStoreTest {
    protected CacheStore createCacheStore() throws Exception {
        ConnectionFactoryConfig connectionFactoryConfig = UnitTestDatabaseManager.getUniqueConnectionFactoryConfig();
        TableManipulation tm = UnitTestDatabaseManager.buildDefaultTableManipulation();
        JdbcBinaryCacheStoreConfig config = new JdbcBinaryCacheStoreConfig(connectionFactoryConfig, tm);
        JdbcBinaryCacheStore jdbcBucketCacheStore = new JdbcBinaryCacheStore();
        jdbcBucketCacheStore.init((CacheLoaderConfig)config, (Cache)new CacheDelegate("aName"), this.getMarshaller());
        jdbcBucketCacheStore.start();
        assert (jdbcBucketCacheStore.getConnectionFactory() != null);
        return jdbcBucketCacheStore;
    }

    public void testNotCreateConnectionFactory() throws Exception {
        JdbcBinaryCacheStore jdbcBucketCacheStore = new JdbcBinaryCacheStore();
        JdbcBinaryCacheStoreConfig config = new JdbcBinaryCacheStoreConfig(false);
        config.setCreateTableOnStart(false);
        jdbcBucketCacheStore.init((CacheLoaderConfig)config, (Cache)new CacheDelegate("aName"), (Marshaller)new TestObjectStreamMarshaller());
        jdbcBucketCacheStore.start();
        assert (jdbcBucketCacheStore.getConnectionFactory() == null);
        ConnectionFactory connectionFactory = (ConnectionFactory)EasyMock.createMock(ConnectionFactory.class);
        TableManipulation tableManipulation = (TableManipulation)EasyMock.createMock(TableManipulation.class);
        config.setTableManipulation(tableManipulation);
        tableManipulation.start(connectionFactory);
        tableManipulation.setCacheName("aName");
        EasyMock.replay((Object[])new Object[]{tableManipulation});
        jdbcBucketCacheStore.doConnectionFactoryInitialization(connectionFactory);
        EasyMock.verify((Object[])new Object[]{tableManipulation});
        EasyMock.reset((Object[])new Object[]{tableManipulation, connectionFactory});
        tableManipulation.stop();
        EasyMock.replay((Object[])new Object[]{tableManipulation, connectionFactory});
        jdbcBucketCacheStore.stop();
        EasyMock.verify((Object[])new Object[]{tableManipulation, connectionFactory});
    }
}

