/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.binary;

import org.infinispan.loaders.LockSupportCacheStoreConfig;
import org.infinispan.loaders.jdbc.DatabaseType;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStore;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;

public class JdbcBinaryCacheStoreConfig
extends LockSupportCacheStoreConfig {
    private static final long serialVersionUID = 7659899424935453635L;
    private ConnectionFactoryConfig connectionFactoryConfig = new ConnectionFactoryConfig();
    private TableManipulation tableManipulation = new TableManipulation();
    private boolean createConnectionFatory = true;

    public JdbcBinaryCacheStoreConfig(boolean createConnectionFatory) {
        this.createConnectionFatory = createConnectionFatory;
    }

    public JdbcBinaryCacheStoreConfig(ConnectionFactoryConfig connectionFactoryConfig, TableManipulation tm) {
        this();
        this.connectionFactoryConfig = connectionFactoryConfig;
        this.tableManipulation = tm;
    }

    public JdbcBinaryCacheStoreConfig() {
        this.cacheLoaderClassName = JdbcBinaryCacheStore.class.getName();
    }

    boolean isManageConnectionFactory() {
        return this.createConnectionFatory;
    }

    public void setCreateTableOnStart(boolean createTableOnStart) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setCreateTableOnStart(createTableOnStart);
    }

    public void setDropTableOnExit(boolean dropTableOnExit) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setDropTableOnExit(dropTableOnExit);
    }

    public void setBucketTableNamePrefix(String bucketTableName) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setTableNamePrefix(bucketTableName);
    }

    public void setIdColumnName(String idColumnName) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setIdColumnName(idColumnName);
    }

    public void setIdColumnType(String idColumnType) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setIdColumnType(idColumnType);
    }

    public void setDataColumnName(String dataColumnName) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setDataColumnName(dataColumnName);
    }

    public void setDataColumnType(String dataColumnType) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setDataColumnType(dataColumnType);
    }

    public void setTimestampColumnName(String timestampColumnName) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setTimestampColumnName(timestampColumnName);
    }

    public void setTimestampColumnType(String timestampColumnType) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setTimestampColumnType(timestampColumnType);
    }

    public void setConnectionUrl(String connectionUrl) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setConnectionUrl(connectionUrl);
    }

    public void setUserName(String userName) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setUserName(userName);
    }

    public void setPassword(String password) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setPassword(password);
    }

    public void setDatasourceJndiLocation(String location) {
        this.testImmutability("datasourceJndiLocation");
        this.connectionFactoryConfig.setDatasourceJndiLocation(location);
    }

    public void setDriverClass(String driverClass) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setDriverClass(driverClass);
    }

    public void setConnectionFactoryClass(String connectionFactoryClass) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setConnectionFactoryClass(connectionFactoryClass);
    }

    public JdbcBinaryCacheStoreConfig clone() {
        JdbcBinaryCacheStoreConfig result = (JdbcBinaryCacheStoreConfig)super.clone();
        result.connectionFactoryConfig = this.connectionFactoryConfig.clone();
        result.tableManipulation = this.tableManipulation.clone();
        return result;
    }

    public ConnectionFactoryConfig getConnectionFactoryConfig() {
        return this.connectionFactoryConfig;
    }

    public TableManipulation getTableManipulation() {
        return this.tableManipulation;
    }

    public void setTableManipulation(TableManipulation tableManipulation) {
        this.testImmutability("tableManipulation");
        this.tableManipulation = tableManipulation;
    }

    public void setFetchSize(int fetchSize) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setFetchSize(fetchSize);
    }

    public void setBatchSize(int batchSize) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setBatchSize(batchSize);
    }

    public int getFetchSize() {
        return this.tableManipulation.getFetchSize();
    }

    public int getBatchSize() {
        return this.tableManipulation.getBatchSize();
    }

    public String getDatabaseType() {
        return this.tableManipulation.databaseType == null ? "" : this.tableManipulation.databaseType.toString();
    }

    public void setDatabaseType(String dbType) {
        if (dbType != null) {
            this.tableManipulation.databaseType = DatabaseType.valueOf(dbType.toUpperCase().trim());
        }
    }
}

