/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.mixed;

import org.infinispan.loaders.AbstractCacheStoreConfig;
import org.infinispan.loaders.jdbc.DatabaseType;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStoreConfig;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStore;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStoreConfig;

public class JdbcMixedCacheStoreConfig
extends AbstractCacheStoreConfig {
    private static final long serialVersionUID = -1343548133363285687L;
    private ConnectionFactoryConfig connectionFactoryConfig = new ConnectionFactoryConfig();
    private TableManipulation binaryTableManipulation = new TableManipulation();
    private TableManipulation stringsTableManipulation = new TableManipulation();
    private String key2StringMapper;
    private int binaryConcurrencyLevel = 1024;
    private int stringsConcurrencyLevel = 1024;
    private int lockAcquistionTimeout = 60000;

    public JdbcMixedCacheStoreConfig(ConnectionFactoryConfig connectionFactoryConfig, TableManipulation binaryTableManipulation, TableManipulation stringsTableManipulation) {
        this.connectionFactoryConfig = connectionFactoryConfig;
        this.binaryTableManipulation = binaryTableManipulation;
        this.stringsTableManipulation = stringsTableManipulation;
    }

    public JdbcMixedCacheStoreConfig() {
        this.cacheLoaderClassName = JdbcMixedCacheStore.class.getName();
    }

    public void setConnectionFactoryConfig(ConnectionFactoryConfig connectionFactoryConfig) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig = connectionFactoryConfig;
    }

    public void setBinaryTableManipulation(TableManipulation binaryTableManipulation) {
        this.testImmutability("binaryTableManipulation");
        this.binaryTableManipulation = binaryTableManipulation;
    }

    public void setStringsTableManipulation(TableManipulation stringsTableManipulation) {
        this.testImmutability("stringsTableManipulation");
        this.stringsTableManipulation = stringsTableManipulation;
    }

    JdbcBinaryCacheStoreConfig getBinaryCacheStoreConfig() {
        JdbcBinaryCacheStoreConfig cacheStoreConfig = new JdbcBinaryCacheStoreConfig(false);
        cacheStoreConfig.setTableManipulation(this.binaryTableManipulation);
        cacheStoreConfig.setPurgeSynchronously(true);
        cacheStoreConfig.setLockConcurrencyLevel(this.binaryConcurrencyLevel);
        cacheStoreConfig.setLockAcquistionTimeout(this.lockAcquistionTimeout);
        return cacheStoreConfig;
    }

    JdbcStringBasedCacheStoreConfig getStringCacheStoreConfig() {
        JdbcStringBasedCacheStoreConfig config = new JdbcStringBasedCacheStoreConfig(false);
        config.setTableManipulation(this.stringsTableManipulation);
        config.setPurgeSynchronously(true);
        config.setLockConcurrencyLevel(this.stringsConcurrencyLevel);
        config.setLockAcquistionTimeout(this.lockAcquistionTimeout);
        if (this.key2StringMapper != null) {
            config.setKey2StringMapperClass(this.key2StringMapper);
        }
        return config;
    }

    public void setIdColumnNameForStrings(String idColumnNameForStrings) {
        this.testImmutability("stringsTableManipulation");
        this.stringsTableManipulation.setIdColumnName(idColumnNameForStrings);
    }

    public void setIdColumnTypeForStrings(String idColumnTypeForStrings) {
        this.testImmutability("stringsTableManipulation");
        this.stringsTableManipulation.setIdColumnType(idColumnTypeForStrings);
    }

    public void setTableNamePrefixForStrings(String tableNameForStrings) {
        this.testImmutability("stringsTableManipulation");
        if (tableNameForStrings == null) {
            throw new IllegalArgumentException("Null table name not allowed.");
        }
        if (tableNameForStrings.equals(this.binaryTableManipulation.getTableNamePrefix())) {
            throw new IllegalArgumentException("Same table name is used for both cache loaders, this is not allowed!");
        }
        this.stringsTableManipulation.setTableNamePrefix(tableNameForStrings);
    }

    public void setDataColumnNameForStrings(String dataColumnNameForStrings) {
        this.testImmutability("stringsTableManipulation");
        this.stringsTableManipulation.setDataColumnName(dataColumnNameForStrings);
    }

    public void setDataColumnTypeForStrings(String dataColumnTypeForStrings) {
        this.testImmutability("stringsTableManipulation");
        this.stringsTableManipulation.setDataColumnType(dataColumnTypeForStrings);
    }

    public void setTimestampColumnNameForStrings(String timestampColumnNameForStrings) {
        this.testImmutability("stringsTableManipulation");
        this.stringsTableManipulation.setTimestampColumnName(timestampColumnNameForStrings);
    }

    public void setTimestampColumnTypeForStrings(String timestampColumnTypeForStrings) {
        this.testImmutability("stringsTableManipulation");
        this.stringsTableManipulation.setTimestampColumnType(timestampColumnTypeForStrings);
    }

    public void setCreateTableOnStartForStrings(boolean createTableOnStartForStrings) {
        this.testImmutability("stringsTableManipulation");
        this.stringsTableManipulation.setCreateTableOnStart(createTableOnStartForStrings);
    }

    public void setDropTableOnExitForStrings(boolean dropTableOnExitForStrings) {
        this.testImmutability("stringsTableManipulation");
        this.stringsTableManipulation.setDropTableOnExit(dropTableOnExitForStrings);
    }

    public void setIdColumnNameForBinary(String idColumnNameForBinary) {
        this.binaryTableManipulation.setIdColumnName(idColumnNameForBinary);
    }

    public void setIdColumnTypeForBinary(String idColumnTypeForBinary) {
        this.testImmutability("stringsTableManipulation");
        this.binaryTableManipulation.setIdColumnType(idColumnTypeForBinary);
    }

    public void setTableNamePrefixForBinary(String tableNameForBinary) {
        this.testImmutability("binaryTableManipulation");
        if (tableNameForBinary == null) {
            throw new IllegalArgumentException("Null table name not allowed.");
        }
        if (tableNameForBinary.equals(this.stringsTableManipulation.getTableNamePrefix())) {
            throw new IllegalArgumentException("Same table name is used for both cache loaders, this is not allowed!");
        }
        this.binaryTableManipulation.setTableNamePrefix(tableNameForBinary);
    }

    public void setDataColumnNameForBinary(String dataColumnNameForBinary) {
        this.testImmutability("binaryTableManipulation");
        this.binaryTableManipulation.setDataColumnName(dataColumnNameForBinary);
    }

    public void setDataColumnTypeForBinary(String dataColumnTypeForBinary) {
        this.testImmutability("binaryTableManipulation");
        this.binaryTableManipulation.setDataColumnType(dataColumnTypeForBinary);
    }

    public void setTimestampColumnNameForBinary(String timestampColumnNameForBinary) {
        this.testImmutability("binaryTableManipulation");
        this.binaryTableManipulation.setTimestampColumnName(timestampColumnNameForBinary);
    }

    public void setTimestampColumnTypeForBinary(String timestampColumnTypeForBinary) {
        this.binaryTableManipulation.setTimestampColumnType(timestampColumnTypeForBinary);
    }

    public void setCreateTableOnStartForBinary(boolean createTableOnStartForBinary) {
        this.testImmutability("binaryTableManipulation");
        this.binaryTableManipulation.setCreateTableOnStart(createTableOnStartForBinary);
    }

    public void setDropTableOnExitForBinary(boolean dropTableOnExitForBinary) {
        this.testImmutability("binaryTableManipulation");
        this.binaryTableManipulation.setDropTableOnExit(dropTableOnExitForBinary);
    }

    public void setDriverClass(String driverClass) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setDriverClass(driverClass);
    }

    public void setConnectionUrl(String connectionUrl) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setConnectionUrl(connectionUrl);
    }

    public void setUserName(String userName) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setUserName(userName);
    }

    public void setPassword(String password) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setPassword(password);
    }

    public void setConnectionFactoryClass(String connectionFactoryClass) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setConnectionFactoryClass(connectionFactoryClass);
    }

    public void setDatasourceJndiLocation(String location) {
        this.testImmutability("datasourceJndiLocation");
        this.connectionFactoryConfig.setDatasourceJndiLocation(location);
    }

    public ConnectionFactoryConfig getConnectionFactoryConfig() {
        return this.connectionFactoryConfig;
    }

    public void setKey2StringMapperClass(String name) {
        this.testImmutability("key2StringMapper");
        this.key2StringMapper = name;
    }

    public void setLockConcurrencyLevelForStrings(int concurrencyLevel) {
        this.testImmutability("stringsConcurrencyLevel");
        this.stringsConcurrencyLevel = concurrencyLevel;
    }

    public void setLockConcurrencyLevelForBinary(int concurrencyLevel) {
        this.testImmutability("binaryConcurrencyLevel");
        this.binaryConcurrencyLevel = concurrencyLevel;
    }

    public void setLockAcquistionTimeout(int lockAcquistionTimeout) {
        this.testImmutability("lockAcquistionTimeout");
        this.lockAcquistionTimeout = lockAcquistionTimeout;
    }

    public void setFetchSize(int fetchSize) {
        this.testImmutability("tableManipulation");
        this.binaryTableManipulation.setFetchSize(fetchSize);
        this.stringsTableManipulation.setFetchSize(fetchSize);
    }

    public void setBatchSize(int batchSize) {
        this.testImmutability("tableManipulation");
        this.binaryTableManipulation.setBatchSize(batchSize);
        this.stringsTableManipulation.setBatchSize(batchSize);
    }

    public String getDatabaseType() {
        return this.binaryTableManipulation.databaseType == null ? "" : this.binaryTableManipulation.databaseType.toString();
    }

    public void setDatabaseType(String dbType) {
        if (dbType != null) {
            this.binaryTableManipulation.databaseType = DatabaseType.valueOf(dbType.toUpperCase().trim());
        }
    }

    public JdbcMixedCacheStoreConfig clone() {
        JdbcMixedCacheStoreConfig dolly = (JdbcMixedCacheStoreConfig)super.clone();
        dolly.connectionFactoryConfig = this.connectionFactoryConfig.clone();
        dolly.binaryTableManipulation = this.binaryTableManipulation.clone();
        dolly.stringsTableManipulation = this.stringsTableManipulation.clone();
        return dolly;
    }
}

