/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.stringbased;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.io.ByteBuffer;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.LockSupportCacheStore;
import org.infinispan.loaders.jdbc.DataManipulationHelper;
import org.infinispan.loaders.jdbc.JdbcUtil;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStoreConfig;
import org.infinispan.loaders.jdbc.stringbased.Key2StringMapper;
import org.infinispan.loaders.jdbc.stringbased.TwoWayKey2StringMapper;
import org.infinispan.loaders.jdbc.stringbased.UnsupportedKeyTypeException;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@CacheLoaderMetadata(configurationClass=JdbcStringBasedCacheStoreConfig.class)
public class JdbcStringBasedCacheStore
extends LockSupportCacheStore {
    private static final Log log = LogFactory.getLog(JdbcStringBasedCacheStore.class);
    private static final byte STRING_STREAM_DELIMITER = 100;
    private JdbcStringBasedCacheStoreConfig config;
    private Key2StringMapper key2StringMapper;
    private ConnectionFactory connectionFactory;
    private TableManipulation tableManipulation;
    private DataManipulationHelper dmHelper;
    private String cacheName;

    public void init(CacheLoaderConfig config, Cache cache, StreamingMarshaller m) throws CacheLoaderException {
        super.init(config, cache, m);
        this.config = (JdbcStringBasedCacheStoreConfig)config;
        this.cacheName = cache.getName();
    }

    public void start() throws CacheLoaderException {
        super.start();
        if (this.config.isManageConnectionFactory()) {
            String connectionFactoryClass = this.config.getConnectionFactoryConfig().getConnectionFactoryClass();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Using managed connection factory: " + connectionFactoryClass));
            }
            ConnectionFactory connectionFactory = ConnectionFactory.getConnectionFactory(connectionFactoryClass);
            connectionFactory.start(this.config.getConnectionFactoryConfig());
            this.doConnectionFactoryInitialization(connectionFactory);
        }
        this.key2StringMapper = this.config.getKey2StringMapper();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Using key2StringMapper: " + this.key2StringMapper.getClass().getName()));
        }
        if (this.isUsingPreload()) {
            this.enforceTwoWayMapper("preload");
        }
        if (this.isDistributed()) {
            this.enforceTwoWayMapper("distribution/rehashing");
        }
        this.dmHelper = new DataManipulationHelper(this.connectionFactory, this.tableManipulation, this.marshaller){

            @Override
            protected String getLoadAllKeysSql() {
                return JdbcStringBasedCacheStore.this.tableManipulation.getLoadAllKeysStringSql();
            }

            @Override
            public void loadAllProcess(ResultSet rs, Set<InternalCacheEntry> result) throws SQLException, CacheLoaderException {
                InputStream inputStream = rs.getBinaryStream(1);
                InternalCacheValue icv = (InternalCacheValue)JdbcUtil.unmarshall(JdbcStringBasedCacheStore.this.getMarshaller(), inputStream);
                String keyStr = rs.getString(2);
                Object key = ((TwoWayKey2StringMapper)JdbcStringBasedCacheStore.this.key2StringMapper).getKeyMapping(keyStr);
                result.add(icv.toInternalCacheEntry(key));
            }

            @Override
            public void loadAllKeysProcess(ResultSet rs, Set<Object> keys, Set<Object> keysToExclude) throws SQLException, CacheLoaderException {
                String keyStr = rs.getString(1);
                Object key = ((TwoWayKey2StringMapper)JdbcStringBasedCacheStore.this.key2StringMapper).getKeyMapping(keyStr);
                if (this.includeKey(key, keysToExclude)) {
                    keys.add(key);
                }
            }

            @Override
            public void toStreamProcess(ResultSet rs, InputStream is, ObjectOutput objectOutput) throws CacheLoaderException, SQLException, IOException {
                InternalCacheValue icv = (InternalCacheValue)JdbcUtil.unmarshall(JdbcStringBasedCacheStore.this.getMarshaller(), is);
                String key = rs.getString(2);
                this.marshaller.objectToObjectStream((Object)icv.toInternalCacheEntry((Object)key), objectOutput);
            }

            @Override
            public boolean fromStreamProcess(Object objFromStream, PreparedStatement ps, ObjectInput objectInput) throws SQLException, CacheLoaderException {
                if (objFromStream instanceof InternalCacheEntry) {
                    InternalCacheEntry se = (InternalCacheEntry)objFromStream;
                    ByteBuffer buffer = JdbcUtil.marshall(JdbcStringBasedCacheStore.this.getMarshaller(), se.toInternalCacheValue());
                    ps.setBinaryStream(1, buffer.getStream(), buffer.getLength());
                    ps.setLong(2, se.getExpiryTime());
                    ps.setString(3, (String)se.getKey());
                    return true;
                }
                return false;
            }
        };
    }

    public void stop() throws CacheLoaderException {
        this.tableManipulation.stop();
        if (this.config.isManageConnectionFactory()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Stopping mananged connection factory: " + this.connectionFactory));
            }
            this.connectionFactory.stop();
        }
    }

    protected String getLockFromKey(Object key) throws CacheLoaderException {
        if (!this.key2StringMapper.isSupportedType(key.getClass())) {
            throw new UnsupportedKeyTypeException(key);
        }
        return this.key2StringMapper.getStringMapping(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeLockSafe(InternalCacheEntry ed, String lockingKey) throws CacheLoaderException {
        InternalCacheEntry existingOne = this.loadLockSafe(ed, lockingKey);
        String sql = existingOne == null ? this.tableManipulation.getInsertRowSql() : this.tableManipulation.getUpdateRowSql();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Running sql '" + sql + "' on " + ed + ". Key string is '" + lockingKey + "'"));
        }
        Connection connection = null;
        PreparedStatement ps = null;
        ByteBuffer byteBuffer = JdbcUtil.marshall(this.getMarshaller(), ed.toInternalCacheValue());
        try {
            connection = this.connectionFactory.getConnection();
            ps = connection.prepareStatement(sql);
            ps.setBinaryStream(1, byteBuffer.getStream(), byteBuffer.getLength());
            ps.setLong(2, ed.getExpiryTime());
            ps.setString(3, lockingKey);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                this.logAndThrow(ex, "Error while storing string key to database; key: '" + lockingKey + "', buffer size of value: " + byteBuffer.getLength() + " bytes");
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(connection);
                throw throwable;
            }
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(connection);
        }
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(connection);
    }

    public boolean removeLockSafe(Object key, String keyStr) throws CacheLoaderException {
        boolean bl;
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            String sql = this.tableManipulation.getDeleteRowSql();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Running sql '" + sql + "' on " + keyStr));
            }
            connection = this.connectionFactory.getConnection();
            ps = connection.prepareStatement(sql);
            ps.setString(1, keyStr);
            bl = ps.executeUpdate() == 1;
        }
        catch (SQLException ex) {
            try {
                String message = "Error while storing string keys to database";
                log.error((Object)message, (Throwable)ex);
                throw new CacheLoaderException(message, (Throwable)ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(connection);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(connection);
        return bl;
    }

    public void fromStreamLockSafe(ObjectInput objectInput) throws CacheLoaderException {
        this.dmHelper.fromStreamSupport(objectInput);
    }

    protected void toStreamLockSafe(ObjectOutput objectOutput) throws CacheLoaderException {
        this.dmHelper.toStreamSupport(objectOutput, (byte)100, true);
    }

    protected void clearLockSafe() throws CacheLoaderException {
        this.dmHelper.clear();
    }

    protected Set<InternalCacheEntry> loadAllLockSafe() throws CacheLoaderException {
        return this.dmHelper.loadAllSupport(true);
    }

    protected Set<InternalCacheEntry> loadLockSafe(int maxEntries) throws CacheLoaderException {
        return this.dmHelper.loadSome(maxEntries);
    }

    protected Set<Object> loadAllKeysLockSafe(Set<Object> keysToExclude) throws CacheLoaderException {
        return this.dmHelper.loadAllKeysSupport(keysToExclude);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeInternal() throws CacheLoaderException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            String sql = this.tableManipulation.getDeleteExpiredRowsSql();
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setLong(1, System.currentTimeMillis());
            int result = ps.executeUpdate();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Successfully purged " + result + " rows."));
            }
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
        }
        catch (SQLException ex) {
            this.logAndThrow(ex, "Failed purging JdbcBinaryCacheStore");
        }
        finally {
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
        }
    }

    protected InternalCacheEntry loadLockSafe(Object key, String lockingKey) throws CacheLoaderException {
        InternalCacheEntry inputStream2;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block7: {
            InternalCacheEntry storedEntry;
            block8: {
                conn = null;
                ps = null;
                rs = null;
                String sql = this.tableManipulation.getSelectRowSql();
                conn = this.connectionFactory.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, lockingKey);
                rs = ps.executeQuery();
                if (!rs.next()) break block7;
                InputStream inputStream2 = rs.getBinaryStream(2);
                InternalCacheValue icv = (InternalCacheValue)JdbcUtil.unmarshall(this.getMarshaller(), inputStream2);
                storedEntry = icv.toInternalCacheEntry(key);
                if (!storedEntry.isExpired()) break block8;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Not returning '" + storedEntry + "' as it is expired. It will be removed from DB by purging thread!"));
                }
                InternalCacheEntry internalCacheEntry = null;
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                return internalCacheEntry;
            }
            InternalCacheEntry internalCacheEntry = storedEntry;
            JdbcUtil.safeClose(rs);
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
            return internalCacheEntry;
        }
        try {
            inputStream2 = null;
        }
        catch (SQLException e) {
            try {
                String message = "SQL error while fetching stored entry with key:" + key + " lockingKey: " + lockingKey;
                log.error((Object)message, (Throwable)e);
                throw new CacheLoaderException(message, (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
        return inputStream2;
    }

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return JdbcStringBasedCacheStoreConfig.class;
    }

    protected void logAndThrow(Exception e, String message) throws CacheLoaderException {
        log.error((Object)message, (Throwable)e);
        throw new CacheLoaderException(message, (Throwable)e);
    }

    public boolean supportsKey(Class keyType) {
        return this.key2StringMapper.isSupportedType(keyType);
    }

    public void doConnectionFactoryInitialization(ConnectionFactory connectionFactory) throws CacheLoaderException {
        this.connectionFactory = connectionFactory;
        this.tableManipulation = this.config.getTableManipulation();
        this.tableManipulation.setCacheName(this.cacheName);
        this.tableManipulation.start(connectionFactory);
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public TableManipulation getTableManipulation() {
        return this.tableManipulation;
    }

    private void enforceTwoWayMapper(String where) throws CacheLoaderException {
        if (!(this.key2StringMapper instanceof TwoWayKey2StringMapper)) {
            String message = "In order for JdbcStringBasedCacheStore to support " + where + ", the Key2StringMapper " + "needs to implement TwoWayKey2StringMapper. You should either make " + this.key2StringMapper.getClass().getName() + " implement TwoWayKey2StringMapper or disable " + where + ". See [https://jira.jboss.org/browse/ISPN-579] for more details.";
            log.error((Object)message);
            throw new CacheLoaderException(message);
        }
    }

    public boolean isUsingPreload() {
        return this.cache.getConfiguration() != null && this.cache.getConfiguration().getCacheLoaderManagerConfig() != null && this.cache.getConfiguration().getCacheLoaderManagerConfig().isPreload() != false;
    }

    public boolean isDistributed() {
        return this.cache.getConfiguration() != null && this.cache.getConfiguration().getCacheMode().isDistributed();
    }
}

