/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.mixed;

import org.easymock.EasyMock;
import org.infinispan.Cache;
import org.infinispan.loaders.BaseCacheStoreTest;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStore;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStoreConfig;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.mixed.JdbcMixedCacheStoreTest2")
public class JdbcMixedCacheStoreTest2
extends BaseCacheStoreTest {
    protected CacheStore createCacheStore() throws Exception {
        JdbcMixedCacheStoreConfig jdbcCacheStoreConfig = new JdbcMixedCacheStoreConfig();
        TableManipulation stringsTm = UnitTestDatabaseManager.buildDefaultTableManipulation();
        stringsTm.setTableNamePrefix("STRINGS_TABLE");
        TableManipulation binaryTm = UnitTestDatabaseManager.buildDefaultTableManipulation();
        binaryTm.setTableNamePrefix("BINARY_TABLE");
        ConnectionFactoryConfig cfc = UnitTestDatabaseManager.getUniqueConnectionFactoryConfig();
        jdbcCacheStoreConfig.setConnectionFactoryConfig(cfc);
        jdbcCacheStoreConfig.setStringsTableManipulation(stringsTm);
        jdbcCacheStoreConfig.setBinaryTableManipulation(binaryTm);
        JdbcMixedCacheStore cacheStore = new JdbcMixedCacheStore();
        Cache mockCache = (Cache)EasyMock.createNiceMock(Cache.class);
        EasyMock.expect((Object)mockCache.getName()).andReturn((Object)((Object)((Object)this)).getClass().getName()).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockCache});
        cacheStore.init((CacheLoaderConfig)jdbcCacheStoreConfig, mockCache, this.getMarshaller());
        cacheStore.start();
        return cacheStore;
    }
}

