/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.stringbased;

import org.infinispan.loaders.jdbc.stringbased.DefaultTwoWayKey2StringMapper;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jdbc.stringbased.DefaultTwoWayKey2StringMapperTest")
public class DefaultTwoWayKey2StringMapperTest {
    DefaultTwoWayKey2StringMapper mapper = new DefaultTwoWayKey2StringMapper();

    public void testAssumption() {
        assert (!new Float(3.0f).equals(new Integer(3)));
    }

    public void testString() {
        assert (this.mapper.isSupportedType(String.class));
        assert (this.assertWorks(""));
        assert (this.assertWorks("mircea"));
    }

    public void testShort() {
        assert (this.mapper.isSupportedType(Short.class));
        assert (this.assertWorks((short)2));
    }

    public void testByte() {
        assert (this.mapper.isSupportedType(Byte.class));
        assert (this.assertWorks((byte)2));
    }

    public void testLong() {
        assert (this.mapper.isSupportedType(Long.class));
        assert (this.assertWorks(new Long(2L)));
    }

    public void testInteger() {
        assert (this.mapper.isSupportedType(Integer.class));
        assert (this.assertWorks(2));
    }

    public void testDouble() {
        assert (this.mapper.isSupportedType(Double.class));
        assert (this.assertWorks(2.4));
    }

    public void testFloat() {
        assert (this.mapper.isSupportedType(Float.class));
        assert (this.assertWorks(Float.valueOf(2.1f)));
    }

    public void testBoolean() {
        assert (this.mapper.isSupportedType(Boolean.class));
        assert (this.assertWorks(true));
        assert (this.assertWorks(false));
    }

    private boolean assertWorks(Object key) {
        return this.mapper.getKeyMapping(this.mapper.getStringMapping(key)).equals(key);
    }
}

