/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.stringbased;

import org.infinispan.loaders.jdbc.AbstractNonDelegatingJdbcCacheStoreConfig;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStore;
import org.infinispan.loaders.keymappers.DefaultTwoWayKey2StringMapper;
import org.infinispan.loaders.keymappers.Key2StringMapper;
import org.infinispan.util.Util;

public class JdbcStringBasedCacheStoreConfig
extends AbstractNonDelegatingJdbcCacheStoreConfig {
    private static final long serialVersionUID = 8835350707132331983L;
    private Key2StringMapper key2StringMapper;

    public JdbcStringBasedCacheStoreConfig(ConnectionFactoryConfig connectionFactoryConfig, TableManipulation tableManipulation) {
        this();
        this.connectionFactoryConfig = connectionFactoryConfig;
        this.tableManipulation = tableManipulation;
    }

    public JdbcStringBasedCacheStoreConfig() {
        this.cacheLoaderClassName = JdbcStringBasedCacheStore.class.getName();
    }

    public JdbcStringBasedCacheStoreConfig(boolean manageConnectionFactory) {
        this();
        this.manageConnectionFactory = manageConnectionFactory;
    }

    public Key2StringMapper getKey2StringMapper() {
        if (this.key2StringMapper == null) {
            try {
                this.key2StringMapper = (Key2StringMapper)DefaultTwoWayKey2StringMapper.class.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("This should never happen", e);
            }
        }
        return this.key2StringMapper;
    }

    public void setKey2StringMapperClass(String className) {
        this.testImmutability("key2StringMapper");
        this.key2StringMapper = (Key2StringMapper)Util.getInstance((String)className);
    }

    public void setStringsTableNamePrefix(String stringsTableNamePrefix) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setTableNamePrefix(stringsTableNamePrefix);
    }

    @Override
    public JdbcStringBasedCacheStoreConfig clone() {
        JdbcStringBasedCacheStoreConfig result = (JdbcStringBasedCacheStoreConfig)super.clone();
        result.key2StringMapper = this.key2StringMapper;
        return result;
    }

    @Override
    public String toString() {
        return "JdbcStringBasedCacheStoreConfig{key2StringMapper=" + this.key2StringMapper + "} " + super.toString();
    }
}

