/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.infinispan.io.ByteBuffer;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JdbcUtil {
    private static final Log log = LogFactory.getLog(JdbcUtil.class);

    public static void safeClose(Statement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void safeClose(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void safeClose(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static ByteBuffer marshall(StreamingMarshaller marshaller, Object bucket) throws CacheLoaderException, InterruptedException {
        try {
            return marshaller.objectToBuffer(bucket);
        }
        catch (IOException e) {
            String message = "I/O failure while marshalling " + bucket;
            log.error((Object)message, (Throwable)e);
            throw new CacheLoaderException(message, (Throwable)e);
        }
    }

    public static Object unmarshall(StreamingMarshaller marshaller, InputStream inputStream) throws CacheLoaderException {
        try {
            return marshaller.objectFromInputStream(inputStream);
        }
        catch (IOException e) {
            String message = "I/O error while unmarshalling from stream";
            log.error((Object)message, (Throwable)e);
            throw new CacheLoaderException(message, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            String message = "*UNEXPECTED* ClassNotFoundException. This should not happen as Bucket class exists";
            log.error((Object)message, (Throwable)e);
            throw new CacheLoaderException(message, (Throwable)e);
        }
    }
}

