/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc;

import java.sql.Connection;
import java.util.HashSet;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.connectionfactory.PooledConnectionFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.PooledConnectionFactoryTest", enabled=false, description="This test is disabled due to: http://sourceforge.net/tracker/index.php?func=detail&aid=1892195&group_id=25357&atid=383690")
public class PooledConnectionFactoryTest {
    private PooledConnectionFactory factory;

    @AfterMethod
    public void destroyFacotry() {
        this.factory.stop();
    }

    public void testValuesNoOverrides() throws Exception {
        this.factory = new PooledConnectionFactory();
        ConnectionFactoryConfig config = UnitTestDatabaseManager.getUniqueConnectionFactoryConfig();
        this.factory.start(config);
        int hadcodedMaxPoolSize = this.factory.getPooledDataSource().getMaxPoolSize();
        HashSet<Connection> connections = new HashSet<Connection>();
        for (int i = 0; i < hadcodedMaxPoolSize; ++i) {
            connections.add(this.factory.getConnection());
        }
        assert (connections.size() == hadcodedMaxPoolSize);
        assert (this.factory.getPooledDataSource().getNumBusyConnections() == hadcodedMaxPoolSize);
        for (Connection conn : connections) {
            conn.close();
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 2000L && this.factory.getPooledDataSource().getNumBusyConnections() != 0) {
        }
        assert (this.factory.getPooledDataSource().getNumBusyConnections() == 0);
    }
}

