/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.binary;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.io.ByteBuffer;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.bucket.Bucket;
import org.infinispan.loaders.bucket.BucketBasedCacheStore;
import org.infinispan.loaders.jdbc.DataManipulationHelper;
import org.infinispan.loaders.jdbc.JdbcUtil;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStoreConfig;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.logging.Log;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.logging.LogFactory;

@CacheLoaderMetadata(configurationClass=JdbcBinaryCacheStoreConfig.class)
public class JdbcBinaryCacheStore
extends BucketBasedCacheStore {
    private static final Log log = (Log)LogFactory.getLog(JdbcBinaryCacheStore.class, Log.class);
    private static final byte BINARY_STREAM_DELIMITER = 100;
    private JdbcBinaryCacheStoreConfig config;
    private ConnectionFactory connectionFactory;
    TableManipulation tableManipulation;
    private DataManipulationHelper dmHelper;
    private String cacheName;

    public void init(CacheLoaderConfig config, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        if (log.isTraceEnabled()) {
            log.tracef("Initializing JdbcBinaryCacheStore %s", config);
        }
        super.init(config, cache, m);
        this.config = (JdbcBinaryCacheStoreConfig)config;
        this.cacheName = cache.getName();
    }

    public void start() throws CacheLoaderException {
        super.start();
        String connectionFactoryClass = this.config.getConnectionFactoryConfig().getConnectionFactoryClass();
        if (this.config.isManageConnectionFactory()) {
            ConnectionFactory factory = ConnectionFactory.getConnectionFactory(connectionFactoryClass);
            factory.start(this.config.getConnectionFactoryConfig());
            this.doConnectionFactoryInitialization(factory);
        }
        this.dmHelper = new DataManipulationHelper(this.connectionFactory, this.tableManipulation, this.marshaller){

            @Override
            protected String getLoadAllKeysSql() {
                return JdbcBinaryCacheStore.this.tableManipulation.getLoadAllKeysBinarySql();
            }

            @Override
            public void loadAllProcess(ResultSet rs, Set<InternalCacheEntry> result) throws SQLException, CacheLoaderException {
                InputStream binaryStream = rs.getBinaryStream(1);
                Bucket bucket = (Bucket)JdbcUtil.unmarshall(JdbcBinaryCacheStore.this.getMarshaller(), binaryStream);
                for (InternalCacheEntry ice : bucket.getStoredEntries()) {
                    if (ice.isExpired()) continue;
                    result.add(ice);
                }
            }

            @Override
            public void loadAllKeysProcess(ResultSet rs, Set<Object> keys, Set<Object> keysToExclude) throws SQLException, CacheLoaderException {
                InputStream binaryStream = rs.getBinaryStream(1);
                Bucket bucket = (Bucket)JdbcUtil.unmarshall(JdbcBinaryCacheStore.this.getMarshaller(), binaryStream);
                for (InternalCacheEntry ice : bucket.getStoredEntries()) {
                    if (ice.isExpired() || !this.includeKey(ice.getKey(), keysToExclude)) continue;
                    keys.add(ice.getKey());
                }
            }

            @Override
            public void toStreamProcess(ResultSet rs, InputStream is, ObjectOutput objectOutput) throws CacheLoaderException, SQLException, IOException {
                Bucket bucket = (Bucket)JdbcUtil.unmarshall(JdbcBinaryCacheStore.this.getMarshaller(), is);
                String bucketName = rs.getString(2);
                this.marshaller.objectToObjectStream((Object)bucketName, objectOutput);
                this.marshaller.objectToObjectStream((Object)bucket, objectOutput);
            }

            @Override
            public boolean fromStreamProcess(Object bucketName, PreparedStatement ps, ObjectInput objectInput) throws SQLException, CacheLoaderException, IOException, ClassNotFoundException, InterruptedException {
                if (bucketName instanceof String) {
                    Bucket bucket = (Bucket)this.marshaller.objectFromObjectStream(objectInput);
                    ByteBuffer buffer = JdbcUtil.marshall(JdbcBinaryCacheStore.this.getMarshaller(), bucket);
                    ps.setBinaryStream(1, buffer.getStream(), buffer.getLength());
                    ps.setLong(2, bucket.timestampOfFirstEntryToExpire());
                    ps.setString(3, (String)bucketName);
                    return true;
                }
                return false;
            }
        };
    }

    public void stop() throws CacheLoaderException {
        this.tableManipulation.stop();
        if (this.config.isManageConnectionFactory()) {
            this.connectionFactory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void insertBucket(Bucket bucket) throws CacheLoaderException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            String sql = this.tableManipulation.getInsertRowSql();
            ByteBuffer byteBuffer = JdbcUtil.marshall(this.getMarshaller(), bucket);
            if (log.isTraceEnabled()) {
                log.tracef("Running insertBucket. Sql: '%s', on bucket: %s stored value size is %d bytes", sql, bucket, byteBuffer.getLength());
            }
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setBinaryStream(1, byteBuffer.getStream(), byteBuffer.getLength());
            ps.setLong(2, bucket.timestampOfFirstEntryToExpire());
            ps.setString(3, bucket.getBucketIdAsString());
            int insertedRows = ps.executeUpdate();
            if (insertedRows != 1) {
                throw new CacheLoaderException("Unexpected insert result: '" + insertedRows + "'. Expected values is 1");
            }
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
            return;
        }
        catch (SQLException ex) {
            log.sqlFailureInsertingBucket(bucket, ex);
            throw new CacheLoaderException(String.format("Sql failure while inserting bucket: %s", bucket), (Throwable)ex);
            catch (InterruptedException ie) {
                if (log.isTraceEnabled()) {
                    log.trace("Interrupted while marshalling to insert a bucket");
                }
                Thread.currentThread().interrupt();
                return;
            }
        }
        finally {
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
        }
    }

    /*
     * Exception decompiling
     */
    protected void updateBucket(Bucket bucket) throws CacheLoaderException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Bucket loadBucket(Integer keyHashCode) throws CacheLoaderException {
        Bucket bucket;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            rs = null;
            String sql = this.tableManipulation.getSelectRowSql();
            if (log.isTraceEnabled()) {
                log.tracef("Running loadBucket. Sql: '%s', on key: %s", sql, keyHashCode);
            }
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setInt(1, keyHashCode);
            rs = ps.executeQuery();
            if (rs.next()) break block6;
            Bucket bucket2 = null;
            JdbcUtil.safeClose(rs);
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
            return bucket2;
        }
        try {
            String bucketName = rs.getString(1);
            InputStream inputStream = rs.getBinaryStream(2);
            Bucket bucket3 = (Bucket)JdbcUtil.unmarshall(this.getMarshaller(), inputStream);
            bucket3.setBucketId(bucketName);
            bucket = bucket3;
        }
        catch (SQLException e) {
            try {
                log.sqlFailureLoadingKey(String.valueOf(keyHashCode), e);
                throw new CacheLoaderException(String.format("Sql failure while loading key: %s", keyHashCode), (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
        return bucket;
    }

    public Set<InternalCacheEntry> loadAllLockSafe() throws CacheLoaderException {
        return this.dmHelper.loadAllSupport(false);
    }

    public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
        return this.dmHelper.loadAllKeysSupport(keysToExclude);
    }

    protected Set<InternalCacheEntry> loadLockSafe(int maxEntries) throws CacheLoaderException {
        return this.dmHelper.loadSome(maxEntries);
    }

    protected void loopOverBuckets(BucketBasedCacheStore.BucketHandler handler) throws CacheLoaderException {
        throw new UnsupportedOperationException("Should never be called.");
    }

    protected void fromStreamLockSafe(ObjectInput objectInput) throws CacheLoaderException {
        this.dmHelper.fromStreamSupport(objectInput);
    }

    protected void toStreamLockSafe(ObjectOutput objectOutput) throws CacheLoaderException {
        this.dmHelper.toStreamSupport(objectOutput, (byte)100, false);
    }

    protected void clearLockSafe() throws CacheLoaderException {
        this.dmHelper.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeInternal() throws CacheLoaderException {
        String sql;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<Bucket> expiredBuckets = new HashSet<Bucket>();
        int batchSize = 100;
        try {
            String sql2 = this.tableManipulation.getSelectExpiredRowsSql();
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql2);
            ps.setLong(1, System.currentTimeMillis());
            rs = ps.executeQuery();
            while (rs.next()) {
                Integer key = rs.getInt(2);
                if (this.immediateLockForWriting(key)) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Adding bucket keyed %s for purging.", key);
                    }
                    InputStream binaryStream = rs.getBinaryStream(1);
                    Bucket bucket = (Bucket)JdbcUtil.unmarshall(this.getMarshaller(), binaryStream);
                    bucket.setBucketId(key);
                    expiredBuckets.add(bucket);
                    continue;
                }
                if (!log.isTraceEnabled()) continue;
                log.tracef("Could not acquire write lock for %s, this won't be purged even though it has expired elements", key);
            }
        }
        catch (SQLException ex) {
            try {
                this.releaseLocks(expiredBuckets);
                this.connectionFactory.releaseConnection(conn);
                log.failedClearingJdbcCacheStore(ex);
                throw new CacheLoaderException("Failed clearing JdbcBinaryCacheStore", (Throwable)ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(ps);
                JdbcUtil.safeClose(rs);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(ps);
        JdbcUtil.safeClose(rs);
        if (log.isTraceEnabled()) {
            log.tracef("Found following buckets: %s which are about to be expired", expiredBuckets);
        }
        if (expiredBuckets.isEmpty()) {
            return;
        }
        HashSet<Bucket> emptyBuckets = new HashSet<Bucket>();
        try {
            sql = this.tableManipulation.getUpdateRowSql();
            ps = conn.prepareStatement(sql);
            int updateCount = 0;
            Iterator it = expiredBuckets.iterator();
            while (it.hasNext()) {
                Bucket bucket = (Bucket)it.next();
                bucket.removeExpiredEntries();
                if (!bucket.isEmpty()) {
                    ByteBuffer byteBuffer = JdbcUtil.marshall(this.getMarshaller(), bucket);
                    ps.setBinaryStream(1, byteBuffer.getStream(), byteBuffer.getLength());
                    ps.setLong(2, bucket.timestampOfFirstEntryToExpire());
                    ps.setString(3, bucket.getBucketIdAsString());
                    ps.addBatch();
                    if (++updateCount % 100 != 0) continue;
                    ps.executeBatch();
                    if (!log.isTraceEnabled()) continue;
                    log.tracef("Flushing batch, update count is: %d", updateCount);
                    continue;
                }
                it.remove();
                emptyBuckets.add(bucket);
            }
            if (updateCount % 100 != 0) {
                if (log.isTraceEnabled()) {
                    log.tracef("Flushing batch, update count is: %d", updateCount);
                }
                ps.executeBatch();
            }
            if (log.isTraceEnabled()) {
                log.tracef("Updated %d buckets.", updateCount);
            }
        }
        catch (SQLException ex) {
            this.releaseLocks(emptyBuckets);
            this.connectionFactory.releaseConnection(conn);
            log.failedClearingJdbcCacheStore(ex);
            throw new CacheLoaderException("Failed clearing JdbcBinaryCacheStore", (Throwable)ex);
        }
        catch (InterruptedException ie) {
            if (log.isTraceEnabled()) {
                log.trace("Interrupted while marshalling to purge expired entries");
            }
            Thread.currentThread().interrupt();
        }
        finally {
            this.releaseLocks(expiredBuckets);
            JdbcUtil.safeClose(ps);
        }
        if (log.isTraceEnabled()) {
            log.tracef("About to remove empty buckets %s", emptyBuckets);
        }
        if (emptyBuckets.isEmpty()) {
            return;
        }
        try {
            sql = this.tableManipulation.getDeleteRowSql();
            ps = conn.prepareStatement(sql);
            int deletionCount = 0;
            for (Bucket bucket : emptyBuckets) {
                ps.setString(1, bucket.getBucketIdAsString());
                ps.addBatch();
                if (++deletionCount % 100 != 0) continue;
                if (log.isTraceEnabled()) {
                    log.tracef("Flushing deletion batch, total deletion count so far is %d", deletionCount);
                }
                ps.executeBatch();
            }
            if (deletionCount % 100 != 0) {
                int[] batchResult = ps.executeBatch();
                if (log.isTraceEnabled()) {
                    log.tracef("Flushed the batch and received following results: %s", Arrays.toString(batchResult));
                }
            }
        }
        catch (SQLException ex) {
            log.failedClearingJdbcCacheStore(ex);
            throw new CacheLoaderException("Failed clearing JdbcBinaryCacheStore", (Throwable)ex);
        }
        finally {
            this.releaseLocks(emptyBuckets);
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
        }
    }

    private void releaseLocks(Set<Bucket> expiredBucketKeys) {
        for (Bucket bucket : expiredBucketKeys) {
            this.unlock(bucket.getBucketId());
        }
    }

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return JdbcBinaryCacheStoreConfig.class;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void doConnectionFactoryInitialization(ConnectionFactory connectionFactory) throws CacheLoaderException {
        this.connectionFactory = connectionFactory;
        this.tableManipulation = this.config.getTableManipulation();
        this.tableManipulation.setCacheName(this.cacheName);
        this.tableManipulation.start(connectionFactory);
    }

    public TableManipulation getTableManipulation() {
        return this.tableManipulation;
    }

    protected StreamingMarshaller getMarshaller() {
        return super.getMarshaller();
    }
}

