/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.connectionfactory;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.logging.Log;
import org.infinispan.util.Util;
import org.infinispan.util.logging.LogFactory;

public class SimpleConnectionFactory
extends ConnectionFactory {
    private static final Log log = (Log)LogFactory.getLog(SimpleConnectionFactory.class, Log.class);
    private String connectionUrl;
    private String userName;
    private String password;

    @Override
    public void start(ConnectionFactoryConfig config, ClassLoader classLoader) throws CacheLoaderException {
        this.loadDriver(config.getDriverClass(), classLoader);
        this.connectionUrl = config.getConnectionUrl();
        this.userName = config.getUserName();
        this.password = config.getPassword();
        if (log.isTraceEnabled()) {
            log.tracef("Starting connection %s", this);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public Connection getConnection() throws CacheLoaderException {
        try {
            Connection connection = DriverManager.getConnection(this.connectionUrl, this.userName, this.password);
            if (connection == null) {
                throw new CacheLoaderException("Received null connection from the DriverManager!");
            }
            return connection;
        }
        catch (SQLException e) {
            throw new CacheLoaderException("Could not obtain a new connection", (Throwable)e);
        }
    }

    @Override
    public void releaseConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException e) {
            log.failureClosingConnection(e);
        }
    }

    private void loadDriver(String driverClass, ClassLoader classLoader) throws CacheLoaderException {
        if (log.isTraceEnabled()) {
            log.tracef("Attempting to load driver %s", driverClass);
        }
        Util.getInstance((String)driverClass, (ClassLoader)classLoader);
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return "SimpleConnectionFactory{connectionUrl='" + this.connectionUrl + '\'' + ", userName='" + this.userName + '\'' + "} " + super.toString();
    }
}

