/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.infinispan.loaders.BaseCacheStoreTest;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.connectionfactory.SimpleConnectionFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.infinispan.test.jndi.DummyContextFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.ManagedConnectionFactoryTest")
public abstract class ManagedConnectionFactoryTest
extends BaseCacheStoreTest {
    private DummyDataSource ds;

    @BeforeClass(alwaysRun=true)
    public void bindDatasourceInJndi() throws Exception {
        System.setProperty("java.naming.factory.initial", DummyContextFactory.class.getName());
        this.ds = new DummyDataSource();
        this.ds.start();
        InitialContext ic = new InitialContext();
        ic.bind(this.getDatasourceLocation(), (Object)this.ds);
        assert (ic.lookup(this.getDatasourceLocation()) instanceof DummyDataSource);
    }

    public abstract String getDatasourceLocation();

    @AfterClass(alwaysRun=true)
    public void destroyDatasourceAndUnbind() throws NamingException {
        InitialContext ic = new InitialContext();
        ic.unbind(this.getDatasourceLocation());
        assert (ic.lookup(this.getDatasourceLocation()) == null);
        this.ds.stop();
    }

    public void testConcurrency() throws Exception {
    }

    public static class DummyDataSource
    implements DataSource {
        private SimpleConnectionFactory simpleFactory;

        public void start() throws CacheLoaderException {
            ConnectionFactoryConfig config = UnitTestDatabaseManager.getUniqueConnectionFactoryConfig();
            this.simpleFactory = new SimpleConnectionFactory();
            this.simpleFactory.start(config, Thread.currentThread().getContextClassLoader());
        }

        public void stop() {
            this.simpleFactory.stop();
        }

        @Override
        public Connection getConnection() throws SQLException {
            try {
                return this.simpleFactory.getConnection();
            }
            catch (CacheLoaderException e) {
                throw new SQLException(e);
            }
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return this.getConnection();
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            throw new IllegalStateException("This should not be called!");
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            throw new IllegalStateException("This should not be called!");
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            throw new IllegalStateException("This should not be called!");
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            throw new IllegalStateException("This should not be called!");
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new IllegalStateException("This should not be called!");
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            throw new IllegalStateException("This should not be called!");
        }

        @Override
        public Logger getParentLogger() {
            throw new IllegalStateException("This should not be called!");
        }
    }
}

