/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.jdbc.JdbcUtil;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.mockito.Mockito;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.TableManipulationTest")
public class TableManipulationTest {
    Connection connection;
    TableManipulation tableManipulation;
    private ConnectionFactoryConfig cfg;

    @BeforeTest
    public void createConnection() throws Exception {
        this.cfg = UnitTestDatabaseManager.getUniqueConnectionFactoryConfig();
        this.connection = DriverManager.getConnection(this.cfg.getConnectionUrl(), this.cfg.getUserName(), this.cfg.getPassword());
        this.tableManipulation = UnitTestDatabaseManager.buildStringTableManipulation();
        this.tableManipulation.setCacheName("aName");
    }

    @AfterTest(alwaysRun=true)
    public void closeConnection() throws SQLException {
        this.connection.close();
    }

    public void testInsufficientConfigParams() throws Exception {
        TableManipulation other;
        Connection mockConnection;
        block20: {
            mockConnection = (Connection)Mockito.mock(Connection.class);
            Statement mockStatement = (Statement)Mockito.mock(Statement.class);
            Mockito.when((Object)mockConnection.createStatement()).thenReturn((Object)mockStatement);
            other = this.tableManipulation.clone();
            try {
                other.createTable(mockConnection);
            }
            catch (CacheLoaderException e) {
                if ($assertionsDisabled) break block20;
                throw new AssertionError((Object)"We do not expect a failure here");
            }
        }
        other.setDataColumnType(null);
        try {
            other.createTable(mockConnection);
            assert (false) : "missing config param, exception expected";
        }
        catch (CacheLoaderException e) {
            other.setDataColumnType("VARCHAR(255)");
        }
        other.createTable(mockConnection);
        other.setIdColumnName("");
        try {
            other.createTable(mockConnection);
            assert (false) : "missing config param, exception expected";
        }
        catch (CacheLoaderException e) {
            other.setIdColumnName("abc");
        }
        other.createTable(mockConnection);
        other.setDataColumnName(null);
        try {
            other.createTable(mockConnection);
            assert (false) : "missing config param, exception expected";
        }
        catch (CacheLoaderException e) {
            other.setDataColumnName("abc");
        }
        other.createTable(mockConnection);
        other.setDataColumnName(null);
        try {
            other.createTable(mockConnection);
            assert (false) : "missing config param, exception expected";
        }
        catch (CacheLoaderException e) {
            other.setDataColumnName("abc");
        }
        other.createTable(mockConnection);
        other.setTimestampColumnName(null);
        try {
            other.createTable(mockConnection);
            assert (false) : "missing config param, exception expected";
        }
        catch (CacheLoaderException e) {
            other.setDataColumnName("timestamp");
        }
        other.setTimestampColumnType(null);
        try {
            other.createTable(mockConnection);
            assert (false) : "missing config param, exception expected";
        }
        catch (CacheLoaderException e) {
            other.setIdColumnType("BIGINT");
        }
    }

    public void testCreateTable() throws Exception {
        assert (!TableManipulationTest.existsTable(this.connection, this.tableManipulation.getTableName()));
        this.tableManipulation.createTable(this.connection);
        assert (TableManipulationTest.existsTable(this.connection, this.tableManipulation.getTableName()));
    }

    @Test(dependsOnMethods={"testCreateTable"})
    public void testExists() throws CacheLoaderException {
        assert (this.tableManipulation.tableExists(this.connection));
        assert (!this.tableManipulation.tableExists(this.connection, "does_not_exist"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"testExists"})
    public void testDrop() throws Exception {
        assert (this.tableManipulation.tableExists(this.connection));
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement("INSERT INTO " + this.tableManipulation.getTableName() + "(ID_COLUMN) values(?)");
            ps.setString(1, System.currentTimeMillis() + "");
            assert (1 == ps.executeUpdate());
        }
        catch (Throwable throwable) {
            JdbcUtil.safeClose(ps);
            throw throwable;
        }
        JdbcUtil.safeClose((Statement)ps);
        this.tableManipulation.dropTable(this.connection);
        assert (!this.tableManipulation.tableExists(this.connection));
    }

    public void testTableQuoting() throws Exception {
        this.tableManipulation.setCacheName("my.cache");
        assert (!TableManipulationTest.existsTable(this.connection, this.tableManipulation.getTableName()));
        this.tableManipulation.createTable(this.connection);
        assert (TableManipulationTest.existsTable(this.connection, this.tableManipulation.getTableName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean existsTable(Connection connection, String tableName) throws Exception {
        boolean bl;
        Statement st = connection.createStatement();
        ResultSet rs = null;
        try {
            rs = st.executeQuery("select * from " + tableName);
            bl = true;
            JdbcUtil.safeClose((ResultSet)rs);
        }
        catch (SQLException e) {
            boolean bl2 = false;
            return bl2;
        }
        finally {
            JdbcUtil.safeClose(rs);
            JdbcUtil.safeClose((Statement)st);
        }
        JdbcUtil.safeClose((Statement)st);
        return bl;
    }
}

