/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.configuration;

import java.sql.Driver;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.cache.AbstractLockSupportCacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.AbstractJdbcCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;

public abstract class AbstractJdbcCacheStoreConfigurationBuilder<T extends AbstractJdbcCacheStoreConfiguration, S extends AbstractJdbcCacheStoreConfigurationBuilder<T, S>>
extends AbstractLockSupportCacheStoreConfigurationBuilder<T, S> {
    protected String driverClass;
    protected String connectionUrl;
    protected String username;
    protected String password;
    protected String datasource;
    protected String connectionFactoryClass;

    public AbstractJdbcCacheStoreConfigurationBuilder(LoadersConfigurationBuilder builder) {
        super(builder);
    }

    public S driverClass(String driverClass) {
        this.driverClass = driverClass;
        return (S)((Object)((AbstractJdbcCacheStoreConfigurationBuilder)this.self()));
    }

    public S driverClass(Class<? extends Driver> klass) {
        this.driverClass = klass.getName();
        return (S)((Object)((AbstractJdbcCacheStoreConfigurationBuilder)this.self()));
    }

    public S connectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        return (S)((Object)((AbstractJdbcCacheStoreConfigurationBuilder)this.self()));
    }

    public S username(String userName) {
        this.username = userName;
        return (S)((Object)((AbstractJdbcCacheStoreConfigurationBuilder)this.self()));
    }

    public S password(String password) {
        this.password = password;
        return (S)((Object)((AbstractJdbcCacheStoreConfigurationBuilder)this.self()));
    }

    public S datasource(String datasource) {
        this.datasource = datasource;
        return (S)((Object)((AbstractJdbcCacheStoreConfigurationBuilder)this.self()));
    }

    public S connectionFactoryClass(String connectionFactoryClass) {
        this.connectionFactoryClass = connectionFactoryClass;
        return (S)((Object)((AbstractJdbcCacheStoreConfigurationBuilder)this.self()));
    }

    public S connectionFactoryClass(Class<? extends ConnectionFactory> klass) {
        this.connectionFactoryClass = klass.getName();
        return (S)((Object)((AbstractJdbcCacheStoreConfigurationBuilder)this.self()));
    }

    public void validate() {
        super.validate();
        if (this.datasource != null && this.connectionUrl != null) {
            throw new ConfigurationException("Cannot specify both a datasource and a connection URL");
        }
    }

    protected S readInternal(AbstractJdbcCacheStoreConfiguration template) {
        this.connectionFactoryClass(template.connectionFactoryClass());
        this.connectionUrl(template.connectionUrl());
        this.datasource(template.datasource());
        this.driverClass(template.driverClass());
        this.password(template.password());
        this.username(template.userName());
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        return (S)((Object)((AbstractJdbcCacheStoreConfigurationBuilder)this.self()));
    }
}

